package cn.com.duiba.kjy.api.api.enums;

import java.util.Objects;

/**
 * 微信各种账号的业务类型。
 * 如需请求带有access_token 参数的接口，请在{@link  cn.com.duiba.kjy.service.accesstoken.RequestTokenHandle}实现中做相对应的处理
 * Created by dugq on 2019-06-01.
 */
public enum OATypeEnum {
    CONTENT_MAIN_OA(1,OaTargetEnum.OA.getCode(),"内容主体公众号"),
    VIP_OA(2,OaTargetEnum.OA.getCode(),"付费用户的VIP专属公众号"),
    MP(3,2,"客集集主体小程序"),
    CLIENT_PUSH_MP(4,OaTargetEnum.MP.getCode(),"客户接收私信消息的小程序"),

    FISSION_MP(5,OaTargetEnum.MP.getCode(),"微信裂变小程序"),

    GAME_MP(6,OaTargetEnum.MP.getCode(),"抽奖模板小程序"),

    GREETING_MP(7,OaTargetEnum.MP.getCode(),"节日贺卡小程序"),

    INNER_SALE(8,OaTargetEnum.WEB.getCode(),"内部销售web应用"),

    LIVE_USER_MP(9, OaTargetEnum.MP.getCode(), "直播用户端"),

    LIVE_ANCHOR_MP(10, OaTargetEnum.MP.getCode(),"直播管理端"),

    OPEN_PL(11,null,"第三方服务平台"),

    OPEN_OA(12,OaTargetEnum.OA.getCode(),"第三方服务平台服务-直播业务的公众号"),

    OPEN_MP(13, OaTargetEnum.MP.getCode(), "第三方服务平台服务的小程序"),

    PROXY_LIVE_USER_MP(14, OaTargetEnum.MP.getCode(), "代理直播用户小程序"),

    VOICE_LIVE_MP(15,OaTargetEnum.MP.getCode(),"语音直播小程序"),

    LIVE_OA(16, OaTargetEnum.OA.getCode(), "直播公众号"),

    REWARD_MP(17, OaTargetEnum.MP.getCode(), "发奖直播小程序"),

    AI_VIDEO_MP(18, OaTargetEnum.MP.getCode(), "AI跟拍小程序"),

    VIDEO_APP(19, OaTargetEnum.PHONE_APP.getCode(), "短视频APP"),

    OPEN_VIP_OA(21,OaTargetEnum.OA.getCode(),"第三方服务平台服务的客集集账号业务的公众号"),
    ;
    /**
     * 和 user-service {@link cn.com.duiba.user.service.api.enums.oa.OATypeEnum}同步。
     * 由于历史原因，导致二者不和。但type是一致的
     */
    private final Integer type;
    //1:公众号 2：小程序 3:web应用
    private final Integer target;
    private final  String desc;

    OATypeEnum(Integer type,Integer target, String desc) {
        this.type = type;
        this.target = target;
        this.desc = desc;
    }

    public Integer getTarget() {
        return target;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static OATypeEnum typeOf(Integer type) {
        for (OATypeEnum e :values())
            if (Objects.equals(type, e.getType())) {
                return e;
            }
        throw new UnsupportedOperationException("不支持的oa类型");
    }

}
