package cn.com.duiba.kjy.api.api.param.secure;

import cn.com.duiba.kjy.api.api.param.WxBaseParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Size;
import java.util.List;


/**
 * @author liuchao1
 * @version 1.0
 * @date 2020/11/18 14:07
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class BatchMpUserRiskRankParam extends WxBaseParam {

    private static final long serialVersionUID = 3800890145750090898L;

    /**
     * 小程序appId
     */
    @NotBlank(message = "小程序appId不能为空")
    private String appId;

    /**
     * 用户信息集合，批量处理获取结果失败时不会进行重试
     */
    @NotEmpty(message = "用户信息集合不能为空")
    @Size(max = 1000, message = "openid列表个数不能超过1000个")
    private List<RiskRankUserParam> paramList;

    /**
     * 结果需要发送到的mq主题，不传则只记录innerLog不发mq通知
     * 只会将成功获取到结果的数据发送回去
     * 通知结果请看下边的结果返回对象
     * @see cn.com.duiba.kjy.api.api.dto.secure.MpUserRiskRankResultDto
     */
    private String notifyMqTopic;

    /**
     * 结果需要发送到的mq标签，不传则只记录innerLog不发mq通知
     * 只会将成功获取到结果的数据发送回去
     */
    private String notifyMqTag;
}
