package cn.com.duiba.kjy.api.api.remoteservice.util;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 微信二维码智能识别服务
 * 每个公众号一天500次机会。
 *
 * @author 吴文哲
 * @date 2020-09-18 14:03
 **/
@AdvancedFeignClient
public interface RemoteWechatQrCodeService {
    /**
     * 微信通过二维码图片识别二维码内容
     * 一张图片中如果含有多张二维码，只返回第一张。
     *
     * @param qrcodeUrl 二维码图片
     * @return 二维码中的内容
     */
    String scanQrCode(String qrcodeUrl);

    /**
     * 使用给定的oaId来识别
     * 微信通过二维码图片识别二维码内容
     * 一张图片中如果含有多张二维码，只返回第一张。
     *
     * @param oaId   公众号ID。
     * @param imgUrl 二维码图片
     * @return 二维码中的内容
     */
    String scanQrCodeWithOaId(Long oaId, String imgUrl);
}
