package cn.com.duiba.kjy.api.api.dto.wxmessage.wxwork.messagepush;

import cn.com.duiba.kjy.api.api.dto.wxmessage.BaseMessageUserDto;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.Map;

/**
 * 企微推送用户对象群体类
 * @author dugq
 * @date 2021/12/6 12:22 下午
 */
@Data
public class WxWorkMessageUserDto implements BaseMessageUserDto {

    private static final long serialVersionUID = -8183432897815463522L;

    /**
     * 用户所属企业的ID，tb_corp表的ID，tb_users_wxwork表的corpId。
     */
    @NotBlank(message = "请指定企业")
    private Long corpId;

    /**
     * 用户的userKey集合
     * 对应企微的userid。可批量发送，但必须是同一个企业
     * 多个企业时，构造多个 WxWorkMessageUserDto 对象
     */
    private String userKey;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 代理人ID
     */
    private Long sellerId;

    /**
     * 单次推送的唯一标识
     */
    private String uniqueMark;

    /**
     * 自定义的一些参数
     */
    private Map<String,String> customMap;

}
