package cn.com.duiba.kjy.api.api.enums;

import cn.com.duiba.kjy.api.api.dto.wxmessage.wxwork.messagepush.WxWorkBaseMessageDto;

import java.util.Objects;

/**
 * 企微的消息类型
 * 每种类型有自己的param继承自{@link WxWorkBaseMessageDto}
 * 每种类型在wechat-service中有自己的参数转换器，继承自{@link cn.com.duiba.kjy.bo.wxwork.paramformat.ParamBeanConvertor}.
 */
public enum WxMessageTypeEnum {
    TEXT_CONTENT(1,"text","应用文字消息"),
//    CUSTOMER_PIC(2,"image","客服图片消息(公众号和小程序都支持)"),
//    CUSTOMER_VOICE(3,"voice","客服音频消息(仅公众号支持)"),
//    CUSTOMER_MUSIC(4,"music","客服音乐消息(仅公众号支持)"),
//    CUSTOMER_VIDEO(5,"video","客服视频消息(仅公众号支持)"),
//    CUSTOMER_CARD(6,"news","客服卡片消息(仅公众号支持)"),
//    CUSTOMER_MENU(7,"msgmenu","客服菜单消息(仅公众号支持)"),
//    CUSTOMER_MP_CARD(8,"miniprogrampage","客服小程序消息(仅公众号支持)"),
//    CUSTOMER_COUPON(9,"wxcard","客服卡券消息(仅公众号支持)"),
//    TEMPLATE(10,"template","模版消息(公众号和小程序都支持)"),
//    SUBSCRIBE(11,"subscribe","小程序订阅消息(仅小程序支持)"),
//    MP_CUSTOMER_LINK(12,"link","小程序客服图文消息(仅小程序支持)"),
    ;
    /**
     * 系统定义code
     */
    private final Integer code;
    /**
     * 对应微信消息的type
     */
    private final String wxType;
    /**
     * 描述
     */
    private final String desc;

    WxMessageTypeEnum(Integer code, String wxType, String desc) {
        this.code = code;
        this.wxType = wxType;
        this.desc = desc;
    }

    public String getWxType() {
        return wxType;
    }

    public final Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }


    public static WxMessageTypeEnum getByCode(Integer code) {
        for (WxMessageTypeEnum e :values())
            if (Objects.equals(code, e.getCode())) {
                return e;
            }
        throw new UnsupportedOperationException("不支持的消息类型");
    }

}
