package cn.com.duiba.kjy.api.api.param.push;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 批量推送参数
 * @author lizhi
 * @date 2021/12/24 4:49 下午
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class SellerBatchPushParam extends BasePushParam {

    private static final long serialVersionUID = 5910809582286382177L;

    /**
     * 销售信息集合
     */
    @NotNull
    @Size(min = 1, max = 100)
    private List<SellerPushParam> sellers;

    /**
     * 自定义参数，可为null。参数名重复时，优先级：个人自定义>批量自定义>系统自定义
     */
    private Map<String, Serializable> customMap;

    /**
     * 自定义埋点参数，可为null。参数名重复时，优先级：个人自定义>批量自定义>系统自定义
     */
    private Map<String, Serializable> embedMap;
}
