package cn.com.duiba.kjy.api.api.remoteservice.material;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.api.dto.material.PerpetualMaterialDto;
import cn.com.duiba.kjy.api.api.dto.material.PerpetualNewsImageResultDto;
import cn.com.duiba.kjy.api.api.dto.material.PerpetualNewsResultDto;
import cn.com.duiba.kjy.api.api.dto.material.PerpetualResultDto;
import cn.com.duiba.kjy.api.api.dto.material.TemporaryMaterialDto;
import cn.com.duiba.kjy.api.api.dto.material.TemporaryResultDto;
import cn.com.duiba.kjy.api.api.dto.wxmessage.result.PerpetualMaterialResult;
import cn.com.duiba.kjy.api.api.dto.wxmessage.result.TemporaryMaterialResult;
import cn.com.duiba.kjy.api.api.param.material.PerpetualMaterialParam;
import cn.com.duiba.kjy.api.api.param.material.TemporaryMaterialParam;

/**
 * Created by dugq on 2020-03-13.
 */
@AdvancedFeignClient
public interface RemoteUploadMaterialService {

    /**
     * 上传临时素材
     * @param temporaryMaterialDto
     * @return
     */
    @Deprecated
    TemporaryMaterialResult uploadTemporaryMaterial(TemporaryMaterialDto temporaryMaterialDto);

    /**
     * 上传永久素材
     * @param perpetualMaterialDto
     * @return
     */
    @Deprecated
    PerpetualMaterialResult uploadPerpetualMaterial(PerpetualMaterialDto perpetualMaterialDto);


    /**
     * 上传临时素材
     */
    TemporaryResultDto uploadTemporaryMaterials(TemporaryMaterialParam temporaryMaterialParam);

    /**
     * 上传永久素材
     */
    PerpetualResultDto uploadPerpetualMaterials(PerpetualMaterialParam perpetualMaterialParam);


    /**
     * 上传图文消息内的图片获取URL
     * @param url
     * @param oaId 公众号的Id
     * @param fileName 文件名称
     * @return 上传结果
     */
    PerpetualNewsImageResultDto uploadPerpetualMaterialForNews(String url, Long oaId, String fileName);

    /**
     * 新增永久图文素材
     * @param oaId
     * @param title
     * @param content
     * @return
     */
    PerpetualNewsResultDto uploadMaterialNews(Long oaId, String title, String content);


    /**
     * 删除永久素材
     * @param oaId
     * @return
     */
    boolean deletePerpetualMaterial(Long oaId,String mediaId);
}
