package cn.com.duiba.kjy.api.api.utils.sms;

import com.aliyun.dysmsapi20170525.models.AddSmsTemplateRequest;
import com.aliyun.dysmsapi20170525.models.AddSmsTemplateResponse;
import com.aliyun.dysmsapi20170525.models.QuerySmsTemplateRequest;
import com.aliyun.dysmsapi20170525.models.QuerySmsTemplateResponse;
import com.aliyun.dysmsapi20170525.models.SendSmsRequest;
import com.aliyun.dysmsapi20170525.models.SendSmsResponse;
import com.aliyun.teaopenapi.models.Config;
import lombok.extern.slf4j.Slf4j;

/**
 * @author gxy
 * @date 2021/5/27 11:31 上午
 */
@Slf4j
public class SendMessageUtil {
    public static com.aliyun.dysmsapi20170525.Client createClient(String accessKeyId, String accessKeySecret) throws Exception {
        Config config = new Config()
            // 您的AccessKey ID
            .setAccessKeyId(accessKeyId)
            // 您的AccessKey Secret
            .setAccessKeySecret(accessKeySecret);
        // 访问的域名
        config.endpoint = "dysmsapi.aliyuncs.com";
        return new com.aliyun.dysmsapi20170525.Client(config);
    }

    /**
     * 发起模版审核
     *
     * @param accessKeyId 短信服务keyId
     * @param accessKeySecret 短信服务密钥
     * @param templateName 模版名称
     * @param templateType 短信类型
     * @param templateContent 短信内容
     * @param remark 备注
     * @return 模版审核响应
     */
    public static AddSmsTemplateResponse phoneMessageTemplate( String accessKeyId , String accessKeySecret , String templateName , Integer templateType , String templateContent ,String remark){
        com.aliyun.dysmsapi20170525.Client client = null;
        AddSmsTemplateResponse addSmsTemplateResponse = null;
        try {
            client = SendMessageUtil.createClient(accessKeyId, accessKeySecret);
            //发起模版审核
            AddSmsTemplateRequest addSmsTemplateRequest = new AddSmsTemplateRequest();
            //模版名称
            addSmsTemplateRequest.setTemplateName(templateName);
            //短信类型
            addSmsTemplateRequest.setTemplateType(templateType);
            //模版内容
            addSmsTemplateRequest.setTemplateContent(templateContent);
            //短信模版申请说明
            addSmsTemplateRequest.setRemark(remark);
            addSmsTemplateResponse = client.addSmsTemplate(addSmsTemplateRequest);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return addSmsTemplateResponse;
    }

    /**
     * 获取模版审核状态
     * @param accessKeyId 短信服务keyId
     * @param accessKeySecret 短信服务密钥
     * @param templateCode 模版code
     * @return 响应结果
     */
    public static QuerySmsTemplateResponse querySmsTemplate(String accessKeyId , String accessKeySecret , String templateCode){
        com.aliyun.dysmsapi20170525.Client client = null;
        QuerySmsTemplateResponse querySmsTemplateResponse = null;
        try {
            client = SendMessageUtil.createClient(accessKeyId, accessKeySecret);
            QuerySmsTemplateRequest querySmsTemplateRequest = new QuerySmsTemplateRequest();
            //模版CODE
            querySmsTemplateRequest.setTemplateCode(templateCode);
            querySmsTemplateResponse = client.querySmsTemplate(querySmsTemplateRequest);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return querySmsTemplateResponse;
    }

    /**
     * 发送短信
     * @param accessKeyId 短信服务keyId
     * @param accessKeySecret 短信服务密钥
     * @param phones 手机号
     * @param templateCode 模版code
     * @param signName 签名名称
     * @param templateParam 模版中对应的参数
     * @return 响应结果
     */
    public static SendSmsResponse sendPhoneMessage(String accessKeyId , String accessKeySecret ,String phones ,String templateCode ,String signName , String templateParam ){
        com.aliyun.dysmsapi20170525.Client client = null;
        SendSmsResponse sendSmsResponse =null;
        try {
            client = SendMessageUtil.createClient(accessKeyId, accessKeySecret);
            //发送短信
            SendSmsRequest sendSmsRequest = new SendSmsRequest();
            //手机号
            sendSmsRequest.setPhoneNumbers(phones);
            //模版CODE
            sendSmsRequest.setTemplateCode(templateCode);
            //签名名称
            sendSmsRequest.setSignName(signName);
            //模版对应的code
            sendSmsRequest.setTemplateParam(templateParam);
            sendSmsResponse = client.sendSms(sendSmsRequest);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return sendSmsResponse;
    }

}
