package cn.com.duiba.kjy.api.api.dto.wxmessage.wxwork.messagepush.suitemessage;

import cn.com.duiba.kjy.api.api.dto.wxmessage.wxwork.messagepush.WxWorkBaseMessageDto;
import cn.com.duiba.kjy.api.api.enums.WxMessageTypeEnum;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.Map;

/**
 * @author dugq
 * @date 2022/4/9 1:50 下午
 */
@Data
public class WxworkMpMessageDto extends WxWorkBaseMessageDto {
    private static final long serialVersionUID = -6399581113740318832L;

    public WxworkMpMessageDto() {
        super(WxMessageTypeEnum.MINIPROGRAM_NOTICE.getCode());
    }

    /**
     * 小程序appID
     */
    @NotBlank(message = "appid 不能为空")
    private String appId;

    /**
     * 打开页面地址，可附带参数
     */
    @NotBlank(message = "小程序页面地址不能为空")
    private String page;

    @NotBlank(message = "小程序通知描述不能为空")
    private String description;

    /**
     * 第一个item是否大写
     */
    private boolean emphasisFirstItem;

    /**
     * item列表 List<key：value>
     */
    private Map<String,String> contentItem;


}
