package cn.com.duiba.kjy.api.api.dto.wxmessage.wxwork.messagepush.wrap;

import cn.com.duiba.kjy.api.api.dto.wxmessage.wxwork.messagepush.WxWorkBaseMessageDto;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 批量消息
 * @author dugq
 * @date 2021/12/7 7:56 下午
 */
@Data
@ToString(callSuper = true)
public class GroupWxWorkMessageWrapperDto<T extends WxWorkBaseMessageDto> extends WxWorkMessageWrapperDto<T> {
    private static final long serialVersionUID = 5704490586938874214L;

    /**
     * 用户所属企业的ID，tb_corp表的ID，tb_users_wxwork表的corpId。
     * 对应企微的corpid
     */
    @NotBlank(message = "请指定企业")
    private Long corpId;

    /**
     * 发给使用过应用的所有用户,当此参数为true时，不再需要指定 userList 属性
     */
//暂无业务需求    protected boolean sendAll;

    /**
     * 用户的userKey集合
     * 对应企微的userid。可批量发送，但必须是同一个企业
     * 多个企业时，构造多个 WxWorkMessageUserDto 对象
     */
    private List<String> userKeyList;

    /**
     * 指定部门发送，目前暂未维护部门，后续业务如果支持，可直接发送。
     */
//暂无业务需求    private List<String> partyKetList;

    /**
     * 指定标签发送.目前暂未维护标签，后续业务如果支持，可直接发送。
     */
//暂无业务需求    private List<String> tagKeyList;
}
