package cn.com.duiba.kjy.api.api.remoteservice.push;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import javax.annotation.Nonnull;

/**
 * 销售推送相关
 * @author lizhi
 * @date 2022/1/18 10:26 上午
 */
@AdvancedFeignClient
public interface RemoteSellerPushChannelService {

    /**
     * 获取URL前缀
     * @param channelType 渠道类型
     * @see cn.com.duiba.kjy.base.api.enums.ProviderChannelEnum
     * @param channelBizId type=1时是公众号ID，type=2时是企微应用ID，type=3时是第三方appId
     * @return URL前缀（pt，或 oax/加密的渠道ID 或 app/加密的渠道ID 等）
     */
    String getChannelPre(@Nonnull Integer channelType, @Nonnull Long channelBizId);
}
