package cn.com.duiba.kjy.api.api.dto.dingtalk;

import cn.com.duiba.kjy.api.api.dto.dingtalk.builder.BtnArrayActionCardDtcBuilder;
import cn.com.duiba.kjy.api.api.dto.dingtalk.builder.BtnSingleActionCardDtcBuilder;
import cn.com.duiba.kjy.api.api.dto.dingtalk.builder.FeedCardDtcBuilder;
import cn.com.duiba.kjy.api.api.dto.dingtalk.builder.LinkDtcBuilder;
import cn.com.duiba.kjy.api.api.dto.dingtalk.builder.MarkdownDtcBuilder;
import cn.com.duiba.kjy.api.api.dto.dingtalk.builder.TextDtcBuilder;

import java.util.List;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-06-07 09:25
 */
public class DingTalkContentBuilder {

    protected DingTalkContent dingTalkContent = new DingTalkContent();

    /**
     * 创建文本类型消息
     */
    public static TextDtcBuilder createText(){
        final TextDtcBuilder textDtcBuilder = new TextDtcBuilder();
        textDtcBuilder.dingTalkContent.setMsgtype("text");
        return textDtcBuilder;
    }

    /**
     * 创建链接类型消息
     */
    public static LinkDtcBuilder createLink(){
        final LinkDtcBuilder linkDtcBuilder = new LinkDtcBuilder();
        linkDtcBuilder.dingTalkContent.setMsgtype("link");
        return linkDtcBuilder;
    }

    /**
     * 创建markdown类型消息
     */
    public static MarkdownDtcBuilder createMarkdown(){
        final MarkdownDtcBuilder markdownDtcBuilder = new MarkdownDtcBuilder();
        markdownDtcBuilder.dingTalkContent.setMsgtype("markdown");
        return markdownDtcBuilder;
    }

    /**
     * 创建整个卡片跳转类型消息
     */
    public static BtnSingleActionCardDtcBuilder createBtnSingleActionCard(){
        final BtnSingleActionCardDtcBuilder btnSingleActionCardDtcBuilder = new BtnSingleActionCardDtcBuilder();
        btnSingleActionCardDtcBuilder.dingTalkContent.setMsgtype("actionCard");
        return btnSingleActionCardDtcBuilder;
    }

    /**
     * 创建按钮列表卡片跳转类型消息
     */
    public static BtnArrayActionCardDtcBuilder createBtnArrayActionCard(){
        final BtnArrayActionCardDtcBuilder btnArrayActionCardDtcBuilder = new BtnArrayActionCardDtcBuilder();
        btnArrayActionCardDtcBuilder.dingTalkContent.setMsgtype("actionCard");
        return btnArrayActionCardDtcBuilder;
    }

    /**
     * 创建反馈卡片跳转类型消息
     */
    public static FeedCardDtcBuilder createFeedCard(){
        final FeedCardDtcBuilder feedCardDtcBuilder = new FeedCardDtcBuilder();
        feedCardDtcBuilder.dingTalkContent.setMsgtype("feedCard");
        return feedCardDtcBuilder;
    }

    public DingTalkContent build(){
        return dingTalkContent;
    }

    public DingTalkContentBuilder setAtMobiles(List<String> mobiles) {
        this.dingTalkContent.setAtMobiles(mobiles);
        return this;
    }

    public DingTalkContentBuilder setAtUsersIds(List<String> userIds) {
        this.dingTalkContent.setAtUserIds(userIds);
        return this;
    }

    public DingTalkContentBuilder setAtAll(boolean isAtAll) {
        this.dingTalkContent.setAtAll(isAtAll);
        return this;
    }
}
