package cn.com.duiba.kjy.api.api.dto.wxmessage.wxwork.messagepush.wrap;

import cn.com.duiba.kjy.api.api.dto.wxmessage.innerlog.WxSendEmbedDto;
import cn.com.duiba.kjy.api.api.dto.wxmessage.MessageWrapper;
import lombok.Data;
import cn.com.duiba.kjy.api.api.dto.wxmessage.wxwork.messagepush.WxWorkBaseMessageDto;
import javax.validation.constraints.NotNull;

/**
 * Created by dugq on 2020-02-07.
 * 消息的封装类
 */
@Data
public class WxWorkMessageWrapperDto<T extends WxWorkBaseMessageDto> implements MessageWrapper {
    private static final long serialVersionUID = 2301019230465516410L;
    /**
     * 消息体
     */
    @NotNull(message = "消息体不能为空")
    protected T messageDto;

    /**
     * 优先选择user对象的oaID
     * 接受消息的目标公众号
     */
    @NotNull(message = "接受消息的应用不能为空")
    protected Long suiteId;

    /**
     * 推送事件
     */
    protected WxSendEmbedDto wxSendEmbedBean;

}
