package cn.com.duiba.kjy.api.api.enums.push;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * 销售员推送开关配置-推送标签
 * @author lizhi
 * @date 2019/6/24 1:51 PM
 */
@Getter
@AllArgsConstructor
public enum SellerPushSwitchLabelEnum {
    /**
     * 免打扰设置一定要放到第一个，前端对第一个做了特殊处理
     */
    DISTURB(4, "免打扰设置"),
    MATERIAL(1, "素材推送"),
    VISIT_ME(2, "线索推送"),
    VIP_EXCLUSIVE(3, "会员专属"),
    WARNING_REMIND(5, "预警提醒"),
    ;

    private final Integer label;
    private final String labelName;

    public boolean needVip() {
        return Objects.equals(this, VIP_EXCLUSIVE);
    }
}
