package cn.com.duiba.kjy.api.api.param.openpl;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 * Created by dugq on 2022/10/21.
 */
@Setter
@Getter
@ToString
public class MpModifyServerDomainParam implements Serializable {
    private static final long serialVersionUID = -4621592330310429065L;

    /**
     * 服务器域名
     */
    private List<String> requestDomain;
    /**
     * ws长连接域名
     */
    private List<String> wsRequestDomain;
    /**
     * 文件上传域名
     */
    private List<String> uploadDomain;
    /**
     * 文件下载域名
     */
    private List<String> downloadDomain;
    /**
     * udp合法域名
     */
    private List<String> udpDomain;
    /**
     * tcp合法域名
     */
    private List<String> tcpDomain;

    /**
     * request 不合法域名
     */
    private List<String> invalidRequestDomain;


    /**
     * socket 不合法域名
     */
    private List<String> invalidWsRequestDomain;


    /**
     * uploadFile 不合法域名
     */
    private List<String> invalidUploadDomain;

    /**
     * downloadFile 不合法域名
     */
    private List<String> invalidDownloadDomain;

    /**
     * udp 不合法域名
     */
    private List<String> invalidUdpDomain;

    /**
     * tcp 不合法域名
     */
    private List<String> invalidTcpDomain;

    /**
     * 没有经过 icp 备案的域名
     */
    private List<String> noIcpDomain;


}
