package cn.com.duiba.kjy.api.api.param.push;

import lombok.Data;

import java.io.Serializable;

/**
 * 推送配置
 *
 * @author xuzhigang
 * @date 2022/3/28 10:28 上午
 **/
@Data
public class PushConfParam implements Serializable {
    private static final long serialVersionUID = -8929965569718368772L;

    /**
     * 业务推送时是业务枚举值PushBizTypeEnum，自定义推送时是自定义推送配置Id
     * @see cn.com.duiba.kjy.api.api.enums.push.PushBizTypeEnum
     */
    private Long pushBizId;

    /**
     * BI定义的推送ID
     */
    private String pushId;

    /**
     * 0代表是全部，type=1时是公众号ID，type=2时是企微应用ID，type=3时是第三方appId
     */
    private Long channelBizId;

}
