package cn.com.duiba.kjy.api.api.param.push;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Map;

/**
 * 销售指定渠道推送
 * @author lizhi
 * @date 2022/1/14 10:42 上午
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class SellerChannelPushParam extends BasePushParam {

    private static final long serialVersionUID = 7111337535689093617L;

    /**
     * 销售ID
     */
    @NotNull
    private Long sellerId;

    /**
     * 渠道类型：1:个微公众号 2:企业应用 3:第三方APP
     * @see cn.com.duiba.kjy.base.api.enums.ProviderChannelEnum
     */
    @NotNull
    private Integer channelType;

    /**
     * type=1时是公众号ID，type=2时是企微应用ID，type=3时是第三方appId
     * 用于指定某个公众号/企业应用/第三方app推送，可为null
     */
    @NotNull
    private Long channelBizId;

    /**
     * 销售维度的自定义参数，可为null。参数名重复时，优先级：个人自定义>批量自定义>系统自定义
     */
    private Map<String, Serializable> sellerCustomMap;

    /**
     * 销售维度自定义埋点参数，可为null。参数名重复时，优先级：个人自定义>批量自定义>系统自定义
     */
    private Map<String, Serializable> sellerEmbedMap;
}
