package cn.com.duiba.kjy.api.api.remoteservice.shortlink;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.api.dto.shortlink.MpShortLinkDto;
import cn.com.duiba.kjy.api.api.param.shortlink.MpShortLinkParam;

import java.util.List;

/**
 * 小程序短链service
 * @author chentiecheng
 * @date 2021/7/28 11:18 上午
 */
@AdvancedFeignClient
public interface RemoteMpShortLinkService {
    /**
     * 绑定小程序短链
     * @param oaId 小程序id
     * @param shortType 短链类型
     * @see cn.com.duiba.kjy.shorturl.service.api.enums.MpQrCodeDataTypeEnum
     * @param params 参数
     * @return 绑定结果
     */
    List<MpShortLinkDto> bindShortLink(Long oaId,Integer shortType,List<MpShortLinkParam> params);
}
