package cn.com.duiba.kjy.api.api.remoteservice.wxwork.suite;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.api.dto.wxwork.corpsuite.SuiteH5UserInfoDetailDto;
import cn.com.duiba.kjy.api.api.dto.wxwork.corpsuite.SuiteH5UserInfoDto;

/**
 * @author dugq
 * @date 2021/11/29 1:42 下午
 */
@AdvancedFeignClient
public interface RemoteCorpSuiteH5LoginService {

    /**
     * 静默授权获取用户信息
     * @param suiteKey 企微应用唯一标识，对应企微的suitid
     * @param code 授权码
     * @return 用户信息
     */
    SuiteH5UserInfoDto getUserInfoByCode(String suiteKey, String code);

    /**
     * 手动授权获取用户信息
     * @param suiteKey 企微应用唯一标识，对应企微的suitid
     * @param userTicket 用户票据
     * @return 用户信息
     */
    SuiteH5UserInfoDetailDto getUserInfoDetailByCode(String suiteKey, String userTicket);
}
