/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.api.utils;

import cn.com.duiba.kjy.api.api.dto.menu.ButtonDto;
import cn.com.duiba.kjy.api.api.dto.menu.MatchRuleDto;
import cn.com.duiba.kjy.api.api.dto.menu.SubButtonDto;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class WxMenuEqualsUtils
implements Serializable {
    private static final long serialVersionUID = -1973210433453047505L;

    public static boolean isSameButton(List<ButtonDto> button1, List<ButtonDto> button2) {
        if (!WxMenuEqualsUtils.isSameListSize(button1, button2)) {
            return false;
        }
        if (CollectionUtils.isEmpty(button1)) {
            return true;
        }
        for (int i = 0; i < button1.size(); ++i) {
            boolean sameButton = WxMenuEqualsUtils.isSameButton(button1.get(i), button2.get(i));
            if (sameButton) continue;
            return false;
        }
        return true;
    }

    public static boolean isSameMatchRule(MatchRuleDto ruleDto1, MatchRuleDto ruleDto2) {
        if (ruleDto1 == null && ruleDto2 == null) {
            return true;
        }
        if (ruleDto1 == null || ruleDto2 == null) {
            return false;
        }
        if (!WxMenuEqualsUtils.isSameStr(ruleDto1.getTagId(), ruleDto2.getTagId())) {
            return false;
        }
        if (!WxMenuEqualsUtils.isSameStr(ruleDto1.getSex(), ruleDto2.getSex())) {
            return false;
        }
        if (!WxMenuEqualsUtils.isSameStr(ruleDto1.getClientPlatformType(), ruleDto2.getClientPlatformType())) {
            return false;
        }
        if (!WxMenuEqualsUtils.isSameStr(ruleDto1.getCountry(), ruleDto2.getCountry())) {
            return false;
        }
        if (!WxMenuEqualsUtils.isSameStr(ruleDto1.getProvince(), ruleDto2.getProvince())) {
            return false;
        }
        if (!WxMenuEqualsUtils.isSameStr(ruleDto1.getCity(), ruleDto2.getCity())) {
            return false;
        }
        return WxMenuEqualsUtils.isSameStr(ruleDto1.getLanguage(), ruleDto2.getLanguage());
    }

    private static boolean isSameButton(ButtonDto button1, ButtonDto button2) {
        if (button1 == null && button2 == null) {
            return true;
        }
        if (button1 == null || button2 == null) {
            return false;
        }
        if (!WxMenuEqualsUtils.isSameStr(button1.getName(), button2.getName())) {
            return false;
        }
        if (!WxMenuEqualsUtils.isSameStr(button1.getType(), button2.getType())) {
            return false;
        }
        if (!WxMenuEqualsUtils.isSameStr(button1.getUrl(), button2.getUrl())) {
            return false;
        }
        if (!WxMenuEqualsUtils.isSameStr(button1.getAppId(), button2.getAppId())) {
            return false;
        }
        if (!WxMenuEqualsUtils.isSameStr(button1.getPagePath(), button2.getPagePath())) {
            return false;
        }
        return WxMenuEqualsUtils.isSameSubButtonList(button1.getSubButton(), button2.getSubButton());
    }

    private static boolean isSameSubButtonList(List<SubButtonDto> subButton1, List<SubButtonDto> subButton2) {
        if (!WxMenuEqualsUtils.isSameListSize(subButton1, subButton2)) {
            return false;
        }
        if (CollectionUtils.isEmpty(subButton1)) {
            return true;
        }
        for (int i = 0; i < subButton1.size(); ++i) {
            boolean sameSubButton = WxMenuEqualsUtils.isSameSubButton(subButton1.get(i), subButton2.get(i));
            if (sameSubButton) continue;
            return false;
        }
        return true;
    }

    private static boolean isSameSubButton(SubButtonDto subButton1, SubButtonDto subButton2) {
        if (subButton1 == null && subButton2 == null) {
            return true;
        }
        if (subButton1 == null || subButton2 == null) {
            return false;
        }
        if (!WxMenuEqualsUtils.isSameStr(subButton1.getName(), subButton2.getName())) {
            return false;
        }
        if (!WxMenuEqualsUtils.isSameStr(subButton1.getType(), subButton2.getType())) {
            return false;
        }
        if (!WxMenuEqualsUtils.isSameStr(subButton1.getUrl(), subButton2.getUrl())) {
            return false;
        }
        if (!WxMenuEqualsUtils.isSameStr(subButton1.getAppId(), subButton2.getAppId())) {
            return false;
        }
        return WxMenuEqualsUtils.isSameStr(subButton1.getPagePath(), subButton2.getPagePath());
    }

    private static boolean isSameStr(String str1, String str2) {
        if (StringUtils.isBlank((CharSequence)str1) && StringUtils.isBlank((CharSequence)str2)) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)str1) || StringUtils.isBlank((CharSequence)str2)) {
            return false;
        }
        return Objects.equals(str1, str2);
    }

    private static <T> boolean isSameListSize(List<T> list1, List<T> list2) {
        if (CollectionUtils.isEmpty(list1) && CollectionUtils.isEmpty(list2)) {
            return true;
        }
        if (CollectionUtils.isEmpty(list1) || CollectionUtils.isEmpty(list2)) {
            return false;
        }
        return list1.size() == list2.size();
    }
}

