package cn.com.duiba.kjy.api.api.dto.spider;

import lombok.Data;

import java.io.Serializable;

/**
 * 用户头像下载消息对象
 *
 * @Author chentiecheng
 * @Date 2020/12/26 11:29 上午
 */
@Data
public class UserAvatarDto implements Serializable {

    private static final long serialVersionUID = 2761049448507592267L;
    /**
     * 用户id，对应tb_users表主键id
     */
    private Long id;

    /**
     * 对应的业务id
     */
    private Integer bizId;

    /**
     * 用户的昵称
     */
    private String nickname;

    /**
     * 抓取微信头像
     * <p>
     * 消息体: {id: 自定义的实体ID，抓取成功之后回回传, url: 需要抓取的图片url}
     * <p>
     * <p>
     * 抓取完头像后回传的消息
     * <p>
     * 消息体: {id: 上面传过来的id, url: 上传到oss的地址,如：http://yun.duiba.com.cn/kjy/nc/avatar/5e50fb84.jpg}
     */
    private String url;
    /**
     * 回调tag
     */
    private String callBackTag;
    /**
     * 消息回调topic
     */
    private String callBackTopic;
}
