package cn.com.duiba.kjy.api.api.dto.wxwork.account;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author xuzhigang
 * @date 2023/6/29 10:48
 **/
@Data
public class UserActiveInfoDto implements Serializable {
    /**
     * 激活状态 0-未激活 1-已激活
     */
    private Integer activeStatus;

    /**
     * 账号列表 帐号列表，同一个userid同类帐号最多只能有一个
     */
    private List<ActiveInfo> activeInfoList;

    @Data
    public static class ActiveInfo implements Serializable {
        /**
         * 帐号激活码
         */
        private String activeCode;

        /**
         * 帐号类型：1:基础帐号，2:互通帐号
         */
        private Integer type;

        /**
         * 帐号绑定激活的成员userid。返回加密的userid
         */
        private String userId;

        /**
         * 激活时间
         */
        private long activeTime;

        /**
         * 过期时间
         */
        private long expireTime;
    }
}
