package cn.com.duiba.kjy.api.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang.StringUtils;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 推送事件
 * @author lizhi
 * @date 2021/11/16 2:51 下午
 */
@Getter
@AllArgsConstructor
public enum PushEventEnum {
    //推送事件类型， 推送类型
    //推送事件类型（S1、S2...），一定要产品定义！！！
    SUBSCRIBE_WELCOME("S1", "关注公众号"),
    SUBSCRIBE_FROM_CONTENT("S2", "通过内容页二维码关注公众号"),
    SCAN_PROM("S4", "会销五折优惠码"),
    ACTIVATION("S5", "开通会员"),
    VISIT_FIRST("S6", "内容第一次访客来访"),
    VISIT_NON_FIRST("S7", "内容非第一次访客来访"),
    ACTIVITY_FORM_SUBMIT("S8", "活动表单提交"),
    PRIVATE_CHAT_ACCESS("S10", "进入聊天界面通知"),
    PRIVATE_CHAT_SEND("S11", "聊天通知"),
    STATISTICS_WEEK("D4", "每周访问数据统计"),
    DAILY("D5", "早报推送"),
    EVENING("D6", "晚安心语"),
    HOT_CONTENT("D7", "热门文章"),
    DISTRIBUTION("V1", "已邀请好友关注"),
    REWARDED("V2", "获得奖励提醒"),
    STATISTICS_VIP_INCOME("V4", "每日收益推送"),
    SUBSCRIBE_WELCOME_EXPAND("V11", "新用户关注公众号-人脉拓展"),
    SUBSCRIBE_WELCOME_WELFARE("V12", "新用户关注公众号-新人礼品"),
    INTERACTIVE_PUSH("S12", "互动推送"),
    FORWARD_CONTENT_PUSH("S14", "客户转发素材通知"),
    FORWARD_SELLER_CARD_PUSH("S15", "客户转发名片通知"),
    ACTIVITY_FORM_SUBMIT_NON_REAL_TIME("S17", "活动表单提交-非实时"),
    ACTIVITY_FORM_SUBMIT_LOTTERY("S18", "活动中奖"),
    WEEKLY_THUMBS_UP("S19", "周报点赞"),
    LIKE_CARD_INTERACTION("S23", "名片点赞通知"),
    ACTIVITY_FORM_HAS_SOURCE("S24", "有内容来源的活动表单提交"),
    RECEIVE_INSURANCE("S31", "私信领取赠险"),
    CLICK_CONTACT_PHONE("S28", "点击电话联系"),
    CLICK_CONTACT_WX("S29", "点击微信联系"),
    READING("S30", "阅读完成"),
    CLICK_CONTACT("S32", "点联系TA"),
    LIKE_CARD_INTERACTION_FROM_OTHER("S33", "来自其它素材页的名片点赞通知"),
    INVITATION_ACCEPT_PUSH("S56", "访客接受邀请函推送"),

    HOT_CONTENT_CHANGE("S80", "换一批热点新闻"),

    INVITATION_PUSH_ENTRY("S115", "邀请函制作功能入口"),

    FISSION_CLICK_ADD_WECHAT_CARD("S121", "裂变点击加微信好友卡片"),

    PROMOTION_WILL_EXPIRE_REMIND("S140", "占用的优惠码，有效期2天，进行推送提醒"),

    KEYWORD_MATERIAL_REPLY("S142", "关键词回复，获取资料"),

    FIRST_SUBSCRIBE_VIP_ACCOUNT_GUIDE_PUSH("S152", "VIP公众号首次关注引导"),

    PROMOTION_PAY_REMIND("S200", "超过两个小时扫码没付费的用户，进行推送提醒"),

    GAME_TEMPLATE_LOTTERY("S300", "抽奖工具：参与抽奖聚合推送"),
    GAME_TEMPLATE_LOTTERY_CUSTOM("S301", "抽奖工具：中销售员指定奖品"),

    GAME_TEMPLATE_RECEIVED_CUSTOM("S302", "抽奖工具：领取销售员指定奖品"),
    SELLER_CARD_APPRAISE_PUSH("S320", "名片客户首次评价推送"),

    CUSTOMIZE_PUSH_1("Z1", "自定义推送"),
    CUSTOMIZE_PUSH_2("Z2", "自定义推送"),
    CUSTOMIZE_PUSH_3("Z3", "自定义推送"),
    CUSTOMIZE_PUSH_4("Z4", "自定义推送"),
    CUSTOMIZE_PUSH_5("Z5", "自定义推送"),
    CUSTOMIZE_PUSH_6("Z6", "自定义推送"),
    CUSTOMIZE_PUSH_7("Z7", "自定义推送"),
    CUSTOMIZE_PUSH_8("Z8", "自定义推送"),
    CUSTOMIZE_PUSH_9("Z9", "自定义推送"),
    CUSTOMIZE_PUSH_10("Z10", "自定义推送"),
    CUSTOMIZE_PUSH_11("Z11", "自定义推送"),
    CUSTOMIZE_PUSH_12("Z12", "自定义推送"),
    CUSTOMIZE_PUSH_13("Z13", "自定义推送"),
    CUSTOMIZE_PUSH_14("Z14", "自定义推送"),
    CUSTOMIZE_PUSH_15("Z15", "自定义推送"),

    INTERACT_WILL_EXPIRE_REMIND46("H1", "连续46小时未和公众号进行互动的用户推送"),
    INTERACT_WILL_EXPIRE_REMIND47("H2", "连续47小时50分钟未和公众号进行互动的用户推送"),
    INTERACT_EXPIRE_REMIND_MORNING("H3", "连续48小时未和公众号进行互动的用户-每日6:30推送"),
    INTERACT_WILL_EXPIRE_REMIND_NIGHT("H4", "连续48小时未和公众号进行互动的用户-每日17:30推送"),
    INTERACT_WILL_EXPIRE_REMIND46_REPLY("H5", "用户回复唤醒小客"),
    INTERACT_WILL_EXPIRE_REMIND47_REPLY("H6", "用户回复激活小客"),
    INTERACT_EXPIRE_REMIND_WHO_LOOK_ME("H7", "用户今天收到了48小时后唤醒（H3 or H4） 且 第一次打开【谁看过我】页面"),
    INTERACT_WILL_EXPIRE_REMIND_REPLY_WITHDRAW("H8", "用户回复马上提现"),
    INTERACT_WILL_EXPIRE_REMIND_REPLY_FORTUNE("H9", "用户回复获取运势"),

    WAKE_UP_PUSH_REPLY("H9", "唤醒推送回复"),
    INTERACT_EXPIRE_REMIND_UNSUBSCRIBE_REPLY("H10", "沉睡用户唤醒推送退订回复"),
    TODAY_LUCK_EVENT_RELY("H11", "今日运势公众号回复推送"),

    INTERACT_EXPIRE_REMIND_BEYOND_LIMIT("H15", "唤醒客服接口下行条数超过上限的用户推送"),

    INTERACT_WILL_EXPIRE_REMIND46_REPLY_FOR_UNLOCK("H20", "首次预警，解锁微信限制回复"),

    WAKE_UP_CLUES_REPLY("H22", "唤醒关键字线索回复"),
    WAKE_UP_ACTIVITY_REPLY("H23", "唤醒关键字趣味测试回复"),
    WAKE_UP_STRATEGY_REPLY("H24", "唤醒关键字使用攻略回复"),
    WAKE_UP_NO_CONTENT_REPLY("H25", "唤醒关键字当日无内容回复"),

    //节日贺卡
    GREETING_CARD_RECEIVE("S123", "节日贺卡：访问收下了贺卡"),
    GREETING_CARD_MAKE_SUCCESS("S130", "节日贺卡制作完成"),
    GREETING_CARD_RECEIVE_TIMEOUT("S132", "节日贺卡访客领取红包超时"),
    GREETING_CARD_REFUND_SUCCESS("S133", "节日贺卡红包退款成功"),
    GREETING_CARD_REFUND_FAIL("S134", "节日贺卡红包退款失败"),
    GREETING_CARD_RECEIVE_SUCCESS("S128", "节日贺卡访客领取红包成功"),
    GREETING_CARD_CHARGE_SUCCESS("S131", "节日贺卡红包充值成功"),
    GREETING_CARD_VISITOR_VIEW("S135", "节日贺卡付费增长访客预览"),

    GREETING_CARD_RECEIVE_GIFT("S137", "节日贺卡访客领取了礼物"),
    GREETING_CARD_RECEIVE_GIFT_REPLENISH("S138", "节日贺卡访客通知代理人补货"),
    GREETING_CARD_RECEIVE_FAIL("S139", "节日贺卡访客领取红包失败"),
    // 线索1.0
    DEPT_VISIT("S143", "深度访问"),
    FREQUENTLY_VISIT("S144", "累计访问"),
    SPECIAL_CUSTOMER_VISIT("S145", "特别关注客户访问"),
    PRODUCT_VISIT("S147", "访问产品文章"),

    INSURANCE_VISIT("S149", "1个月内累计有效阅读3个保险类素访问事件"),
    ASK_EMPLOY_INFO("S154", "询问招聘类信息"),
    LOOK_OVER_COMPANY_INFO("S155", "查看公司信息"),
    REVENUE_TALK_MATERIAL("S156", "创说会留资"),
    CLUE_ACTIVITY_SUMIT_MATERIAL_3("S158", "线索游戏提交资料推送3"),
    FAQ_PRIVATE_VISIT_2("S159", "种草素材-FAQ&私信气泡2"),
    FAQ_PRIVATE_VISIT_3("S160", "种草素材-FAQ&私信气泡3"),
    RECRUIT_FAQ_VISIT("S161", "增员专题类FAQ"),
    LOOK_OVER_HEADWORD("S172", "种草正文内仅查看词条"),
    HEADWORD_FAQ_VISIT("S173", "查看词条并点击互助问答"),
    EXPLOSION_VOTE("S174", "参与种草素材文章内的投票"),
    LOOK_OVER_CLAIM_CASE("S175", "查看理赔案例"),
    LOOK_OVER_PRODUCT_ARTICLE("S183", "种草文章内的产品文章"),
    LOOK_OVER_FAQ("S182", "种草文章内的互助问答"),

    MORE_EVENING_CONTENT("S162", "晚安心语查看更多"),
    //贺卡发圈素材
    DAILY_SIGN_GREETING_PUSH("S152", "贺卡发圈素材"),
    //自动回复
    ALL_AUTO_REPLY("S310", "自动回复统一推送事件"),

    //销售客户生日提醒推送
    BIRTH_REMIND_PUSH("S170", "生日提醒推送"),

    //节日提醒推送
    SELLER_HOLIDAY_REMIND_PUSH("S178", "客户节日提醒推送"),
    //自定义提醒推送
    SELLER_CUSTOM_REMIND_PUSH("S179", "客户自定义提醒推送"),


    VIP_TRANSFER_CONFIRM_PUSH("S171", "会员迁移确认推送"),

    INVITATION_LETTER_VISIT_PUSH("S319", "邀请函访问推送"),

    PRE_INSTALL_PUSH("L7", "预设会员推送"),
    PRE_INSTALL_CARD_PUSH("L8", "预设会员修改名片推送"),

    LIVE_USER_APPOINTMENT("L5", "直播开播用户订阅消息"),
    LIVE_USER_DRAW("L6", "访客领取权益订阅消息推送"),
    LIVE_NOTIFY_AGENT_IN_NOTICE_TIME("L1", "在直播配置的通知时间通知代理人(客服)"),
    LIVE_NOTIFY_AGENT_BEFORE_BEGIN("L2", "在直播开始前3分钟通知代理人(客服)"),
    LIVE_NOTIFY_AGENT_WHEN_LIVING("L3", "在直播开始中每20分钟通知一次代理人(客服)"),
    LIVE_NOTIFY_AGENT_WHEN_LIVED("L4", "在直播结束将统计数据发给代理人(客服)"),
    LIVE_OA_QR_CODE_RESOURCE("L9", "直播公众号资料推送"),
    LIVE_OUT_LINK("L10", "直播外部链接推送"),
    LIVE_AGENT_NEW_VISITOR_ADVICE("L11", "直播代理人有新访客咨询"),
    LIVE_PUSH_MANAGER("L12", "直播自定义推送"),
    LIVE_NOTIFY_AGENT_AUTO_REPLY("L13", "直播代理人自动回复"),
    LIVE_NOTIFY_AGENT_PRE_INSTALL("L14", "直播代理人激活成功"),
    LIVE_POSTER_AUTO_REPLY("L15", "直播代理人海报自动回复"),
    LIVE_POSTER_PRE_INSTALL("L16", "直播代理人海报激活成功"),
    LIVE_USER_APPOINTMENT_LOTTERY("L17", "直播预约活动开奖通知"),
    LIVE_USER_APPOINTMENT_RED("L18", "直播预约红包领取通知"),
    LIVE_USER_APPOINTMENT_SUBSCRIBE("L19", "直播开播用户订阅关注消息"),
    LIVE_AGENT_STATISTIC_PUSH_BEFORE_START("L20", "开播前,非直播当天代理人邀请/预约数据统计推送"),
    LIVE_AGENT_RANK_PUSH_BEFORE_START("L21", "开播前,代理人排行推送"),
    LIVE_AGENT_INVITE_USER_PUSH_BEFORE_START("L22", "开播前,代理人邀请用户,每10分钟聚合推送"),
    LIVE_USER_APPOINTMENT_PRE_LOTTERY("L23", "直播前中奖通知"),
    LIVE_AGENT_VISITOR_PRE_LOTTERY("L24", "代理人访客直播前中奖通知"),
    LIVE_END_AGENT_CLUE_PUSH("L27", "直播结束给代理人发线索推送"),
    LIVE_END_AGENT_SPECIFY_AWARD_PAY_CODE_PUSH("L28", "直播结束给代理人推送指定中奖付款码"),

    LIVE_SPECIFY_AWARD_USER_PUSH("L25", "访客指定中奖通知推送"),
    LIVE_DRAW_AWARD_AGENT_PUSH("L26", "直播间开奖，中奖客户代理人聚合消息推送"),
    LIVE_ACTIVATE_H5_SHARE_PUSH("L29", "直播代理人激活h5分享链接推送"),
    OPEN_USER_PRE_INSTALL_PUSH("L30", "第三方用户预设会员推送"),
    LIVE_AGENT_VISITOR_LOTTERY("L31", "代理人访客直播中奖通知"),
    LIVE_VISITOR_INVITE("L32", "访客邀请结果通知"),
    VIDEO_SPECIFY_AWARD_AGENT_NOTIFY_PUSH("L33", "视频集锦指定中奖,访客中奖通知代理人推送"),
    // boss看板
    SELLER_TEAM_PUBLISH_TASK("S167", "发布新任务通知"),
    SELLER_TEAM_MANUAL_TASK("S168", "手动提醒任务通知"),

    //文章上传
    SELLER_IMPORT_TASK_FINISH("S184", "文章上传成功推送"),

    MATERIAL_CONTENT_PUSH("D11", "种草素材推送"),

    VIP_RENEW_REMIND("D12", "会员续费提醒"),

    GRASS_CONTENT_MATERIAL_MORNING_PUSH("D13", "每日早上的种草素材推送"),

    MATERIAL_CONTENT_PM_PUSH("D14", "种草素材下午场推送"),
    /**
     * 中奖奖励派发推送
     */
    SELLER_GIFT_PUSH("S190", "中奖奖励派发推送"),
    /*
     * 每日唤醒 海报推送
     */
    DAILY_POSTERS_PUSH("S185", "早报海报推送"),
    GRASS_CONTENT_POSTERS_PUSH("S186", "种草素材海报推送"),
    HOT_ARTICLE_POSTERS_PUSH("S187", "热文海报推送"),
    EVENING_POSTERS_PUSH("S188", "晚安心语海报推送"),

    FAQ_ARTICLE_ASK("S191", "种草素材内的faq点击咨询"),
    FAQ_COLUMN_ASK("S192", "个人专栏内的faq点击咨询"),

    FAQ_VISIT_DETAIL("S193", "种草素材内的faq详情点击"),
    FAQ_VISIT_ASK("S194", "个人专栏内的faq点击咨询"),
    FAQ_VISIT_SCAN("S195", "个人专栏内的faq扫描二维码"),
    FAQ_VISIT_ASK_EXTRA("S196", "faq详情页点击咨询额外问题"),
    IMPORTANT_CLUE("S197", "重要线索提醒"),
    WELFARE_INSURANCE("S198", "赠险领取"),
    RISK_TEST("S199", "风险评测重要线索"),
    ONE_BY_ONE("S201", "1V1专业定制"),
    INSURE_ADVICE("S202", "投保咨询"),
    BILLING_CLOCK_REMIND("S204", "打卡当日提醒"),
    BILLING_CLOCK_UNFINISH("S205", "当日任务未完成"),
    BILLING_CLOCK_REISSUE_REMIND("S206", "补卡提示"),
    INSURE_CALCULATE("S207", "保费测算"),
    NEW_SUBSCRIBE_10_MINUTE_PUSH("S208", "新用户使用教程推送-第1天"),
    NEW_SUBSCRIBE_SECEND_DAY_PUSH("S209", "新用户使用教程推送-第2天"),
    NEW_SUBSCRIBE_THIRD_DAY_PUSH("S210", "新用户使用教程推送-第3天"),
    UNINTERACTION_PUSH("S211", "保险付费用户长时间不活跃推送"),
    ARTICLE_PRIZE("S212", "文内抽奖推送"),
    TIME_LOTTERY_NOT_SET_WIN("S213", "定时抽奖-未设置中奖人员提醒"),
    TIME_LOTTERY_OPEN_SUCCESS("S214", "定时抽奖-已开奖提醒"),
    TIME_LOTTERY_OPEN_FAIL("S215", "定时抽奖-开奖失败提醒"),
    TRY_USE_ACTIVATE_PUSH("S216", "试用码激活推送"),
    NOT_VIP_MATERIAL_PUSH("S217", "非会员线索条数提醒推送"),
    GUESS_QUES_SELLER_PUSH("S218", "代理人端-猜你想问线索通知"),
    AI_VIDEO_NOTIFY_SUCCESS_PUSH("S219", "AI跟拍,视频生成成功推送"),
    SELLER_GAME_UNLOCK_PUSH("S220", "代理人端-模拟人生测评报告领取推送"),
    SELLER_NPS_SURVEY_PUSH("S221", "代理人nps问卷推送"),
    RISK_TEST_WILLING_TO_ACCEPT("S222", "风险测评愿意接受沟通"),
    ACTIVITY_CONSULT_SELLER("S223", "活动页咨询代理人"),
    ATTEND_RED_DAY_PUSH("S224", "签到领红包每日提醒"),
    TEST_GAME_DEGREE_PUSH("S225", "测评小游戏-客户提交表单-推送"),
    CORP_EMPLOYEE_ACTIVATE_PUSH("S226", "企业版激活推送"),
    BIND_INVITATION_FAILED("S227", "绑定邀请关系失败原因推送"),
    PAY_URL_PUSH("S228", "付费链接推送"),
    COMPANY_INSURANCE("S229","公司专区赠险领取"),
    OTO_RISK_PUSH("S230","oto项目养老关键词测评推送"),
    OTO_INVITER_VISIT_PUSH("S231", "oto邀请函访问推送"),
    OTO_INVITER_CONFIRM_PUSH("S232", "oto邀请函确认推送"),

    /**
     * 直播小程序客服消息
     */
    LIVE_USER_REWARD("K1", "直播中奖用户通过客服消息添加代理人微信二维码推送埋点"),
    FEED_BACK_AGENT_EMBED("K2", "直播反馈添加代理人专属客服二维码推送埋点"),
    FEED_BACK_USER_EMBED("K3", "直播反馈添加普通用户客服二维码推送埋点"),

    VOICE_LIVE_OPEN_VISITOR_REMIND("C1", "语音直播开播访客提醒"),
    VOICE_LIVE_OPEN_AGENT_REMIND("C2", "语音直播开播代理人提醒"),

    /**
     * 通知用户开奖结果
     */
    REWARD_RESULT_USER_REMIND("L35", "开奖结果通知"),
    REWARD_APPOINT_WINNER_REMIND("L36", "通知代理人提前设定中奖人"),
    TREASURE_AWARD_CLAIM_REMIND("L37", "裂变宝箱领取通知"),

    /**
     * 翻牌集字
     */
    LIVE_FLIP_WORD_DAILY_CHECKIN("L38", "直播-翻牌集字每日签到提醒"),

    /**
     * 社交亲友券
     */
    LIVE_FISSION_LOTTERY_RECEIVED("L39", "裂变抽奖券-分享者被领取提醒"),

    /**
     * 小程序服务通知
     */
    LIVE_APPOINTMENT_WILL_START_REMIND("L40", "订阅直播即将开始提醒"),
    RED_PACKET_RECEIVE_INFORM("L41", "红包领取通知"),
    LOTTERY_RESULT_INFORM("L42", "抽奖结果通知"),

    /**
     * 秒杀预告
     */
    LIVE_SECOND_KILL_PRE_REMIND("L43", "秒杀预告订阅提醒"),

    LIVE_GOODS_ON_SALE("L44", "直播商品售卖通知"),

    LIVE_GOODS_ON_SALE_AFTER_LIVE_10_MIN("L45", "直播商品售卖通知-开播后10分钟推送"),
    ;
    /**
     * 推送事件类型（值为推送需求中的推送ID）
     */
    private final String eventType;

    /**
     * 推送事件描述
     */
    private final String desc;

    /**
     * key：推送事件类型 value：枚举
     */
    private static final Map<String, PushEventEnum> EVENT_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(PushEventEnum::getEventType, Function.identity(), (v1, v2) -> v1)));

    public static PushEventEnum getByEventType(String eventType){
        if(StringUtils.isBlank(eventType)){
            return null;
        }
        return EVENT_MAP.get(eventType);
    }
}