package cn.com.duiba.kjy.api.api.enums.push;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.collections4.SetUtils;

import java.util.Set;

/**
 * 业务推送类型
 * @author lizhi
 * @date 2021/12/24 5:49 下午
 */
@AllArgsConstructor
@Getter
public enum PushBizTypeEnum {
    DAILY(1L, "早报"),
    GRASS_CONTENT(2L, "种草素材"),
    HOT_CONTENT(3L, "热门文章"),
    EVENING(4L, "晚安心语"),
    VISIT_FIRST(5L, "内容第一次访客来访"),
    VISIT_NON_FIRST(6L, "内容非第一次访客来访"),
    EXPLOSION_VOTE(7L, "总草素材内投票"),
    FAQ_VIEW(8L, "faq-详情查看"),
    FAQ_RECEIVE_DATAGRAM(9L, "faq-资料包领取"),
    FAQ_EXTRA_ASK(10L, "faq-额外咨询"),
    COMPANY_INSURANCE_RECEIVE(11L, "领取赠险"),
    TEST_SUBMIT(12L, "测评提交"),
    TEST_REPORT(13L, "测评领取报告"),
    ;

    /**
     * 业务类型值
     */
    private final Long type;

    /**
     * 业务类型描述
     */
    private final String desc;

    private static Set<Long> clueTypes = SetUtils.unmodifiableSet(EXPLOSION_VOTE.getType(), FAQ_VIEW.getType(), FAQ_RECEIVE_DATAGRAM.getType()
            , FAQ_RECEIVE_DATAGRAM.getType(), FAQ_EXTRA_ASK.getType(), COMPANY_INSURANCE_RECEIVE.getType(), TEST_SUBMIT.getType(), TEST_REPORT.getType());

    /**
     * 是否是线索
     */
    public static boolean isClueType(Long type) {
        return clueTypes.contains(type);
    }
}
