package cn.com.duiba.kjy.api.api.param.qrcode;

import lombok.Data;

import java.io.Serializable;

/**
 * @author dugq
 * @date 2020/11/16 3:40 下午
 */
@Data
public class MpQrcodeParam implements Serializable {

    private static final long serialVersionUID = -5104679335031816966L;

    /**
     * 场景值。即扫码回调参数。<br/>
     * 最大32个可见字符，只支持数字，大小写英文以及部分特殊字符：!#$&'()*+,/:;=?@-._~<br/>
     * 其它字符请自行编码为合法字符（因不支持%，中文无法使用 urlencode 处理，请使用其他编码方式）<br/>
     */
    private String scene;

    /**
     * 扫码跳转小程序页面。<br/>
     * 1、必须是已经发布的小程序存在的页面（否则报错）<br/>
     * 2、不能携带参数<br/>
     * 3、不要以/开头<br/>
     * 4、为空时跳转主页面<br/>
     */
    private String page;

    /**
     *
     * 图片宽度。正方形，宽高相同<br/>
     * 单位：px<br/>
     * 默认值：430px<br/>
     * 最小 280px<br/>
     * 最大 1280px<br/>
     */
    private int width = 430;

    /**
     * 自动配置线条颜色，如果颜色依然是黑色，则说明不建议配置主色调
     * 默认为false 。通过 {@link #lineColor}自定义。
     */
    private boolean autoColor;

    /**
     * 自定义线条颜色。
     * 当且仅当 ： autoColor = false 的时候生效。
     */
    private LineColorParam lineColor;

    /**
     * 是否需要透明底色，为 true 时，生成透明底色的小程序
     * 默认：false
     */
    private boolean hyaline;
}
