package cn.com.duiba.kjy.api.api.remoteservice.dingtalk;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.api.dto.dingtalk.DingTalkContent;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-06-07 13:58
 */
@AdvancedFeignClient
public interface RemoteDingtalkApiService {

    /**
     * 发送钉钉机器人消息（注意频率，1分钟超过20次会被限流）
     * @param url 钉钉机器人webhook，可以在钉钉群-智能群助手-对应机器人-webhook中找到
     * @param dingTalkContent 钉钉消息内容
     * @see cn.com.duiba.kjy.api.api.dto.dingtalk.DingTalkContentBuilder
     * @return 发送结果
     */
    boolean sendRobot(String url, DingTalkContent dingTalkContent);
}
