package cn.com.duiba.kjy.livett.web.api.dto.clue;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播间不同分享类型分享次数表
 * @author youqian mybatis generator 
 * 2021-05-22
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class LiveClueShareTypeTimesDto implements Serializable {
    private static final long serialVersionUID = 16216638325068494L;

    /**
     * 主键
     * not null default = null
     */
    private Long id;

    /**
     * 直播ID
     * not null default = null
     */
    private Long liveId;

    /**
     * 分享次数
     * not null default = 0
     */
    private Integer shareTimes;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 分享类型：1-普通小程序分享，2-手气王小程序分享 4-翻倍红包小程序分享
     * not null default = 1
     */
    private Byte shareType;

    /**
     * 分享文案id
     */
    private Long liveShareConfId;

    /**
     * 用户id
     */
    private Long userId;
}