package cn.com.duiba.kjy.livett.web.api.remoteservice.clue;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livett.web.api.dto.clue.LiveClueSpeakDto;
import cn.com.duiba.kjy.livett.web.api.param.clue.LiveClueSpeakParam4Task;
import cn.com.duiba.kjy.livett.web.api.param.clue.LiveClueSpeakSearchParam;

import java.util.List;

/**
 * Created by dugq on 2020-04-03.
 * 弹幕
 */
@AdvancedFeignClient
public interface RemoteLiveClueSpeakService {

    /**
     * 查询弹幕列表
     * @param param 查询条件
     * @return 弹幕列表
     */
    List<LiveClueSpeakDto> selectList(LiveClueSpeakSearchParam param);

    /**
     * 查询弹幕数量
     * @param param 查询条件
     * @return 弹幕数量
     */
    Long selectCount(LiveClueSpeakSearchParam param);

    /**
     *新增单条弹幕
     * @param liveClueSpeakDto 弹幕信息
     * @return 新增条数
     */
    int insert(LiveClueSpeakDto liveClueSpeakDto);

    /**
     * 批量新增弹幕
     * @param list 弹幕列表
     * @return 新增数量
     */
    int batchInsert(List<LiveClueSpeakDto> list);

    /**
     * 根据条件查询 不分页
     * @param param
     * @return
     */
    List<LiveClueSpeakDto> findByCondition4Task(LiveClueSpeakParam4Task param);
}
