package cn.com.duiba.kvtable.service.api.enums;

/**
 * activity-access-web Hbase第二段key枚举类
 * Created by sunchangji on 2018/7/11.
 */
public enum ActAccessWebHBaseKeyEnum {
    K001("种红包用户土地信息"),
    K002("种红包用户在种红包活动中使用的总积分"),
    K003("全局钱包自然月累计登录天数"),
    K004("推币机总的积分"),
    K005("推币机回收的积分"),

    K011("猜红包活动剩余预算"),
    K012("猜红包助力者永久可助力次数"),
    K013("猜红包红包总共可被猜次数")
    ;

    private String desc;

    ActAccessWebHBaseKeyEnum(String desc){
        this.desc = desc;
    }

    /**
     * 活动web:activity-access-web HBase key space
     */
    private static final String SPACE = "AAWH";

    public String getDesc() {
        return desc;
    }

    /**
     * 拼接key前置
     */
    @Override
    public String toString() {
        return SPACE + "_" + super.toString()+"_";
    }
}
