package cn.com.duiba.kvtable.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kvtable.service.api.dto.KVDto;
import cn.com.duiba.kvtable.service.api.enums.KVSpaceEnum;

import java.util.List;
import java.util.Set;

/**
 * @author liugq
 * @date created in 2018/4/14
 * @description:
 */
@AdvancedFeignClient
public interface RemoteKvTableService {

	/**
	 * 按照vspace,key进行查询
	 * 
	 * @param space
	 * @param consumerId
	 * @param key
	 * @return
	 */
	KVDto get(KVSpaceEnum space, Long consumerId, String key) throws BizException;

	/**
	 * 按照vspace批量查询
	 * 
	 * @param space
	 * @param consumerId
	 * @return
	 */
	List<KVDto> mulGetByKeys(KVSpaceEnum space, Long consumerId, Set<String> keys) throws BizException;

	/**
	 * 单条数据插入
	 * 
	 * @param dto
	 * @return
	 */
	@Deprecated
	Boolean insert(KVDto dto, Long consumerId);

	/**
	 * 批量插入
	 * 
	 * @param dtos
	 * @param consumerId
	 * @return
	 */
	@Deprecated
	Boolean mulInsert(List<KVDto> dtos, Long consumerId);

	/**
	 * 单条数据修改
	 * 
	 * @param dto
	 * @return
	 */
	@Deprecated
	Boolean update(KVDto dto, Long consumerId);

	/**
	 *
	 * @param space
	 * @param key
	 * @param count
	 * @return
	 */
	@Deprecated
	Boolean increase(KVSpaceEnum space, String key, Long consumerId, int count);

	/**
	 *
	 * @param space
	 * @param key
	 * @param count
	 * @return
	 */
	@Deprecated
	Boolean insertOrIncrease(KVSpaceEnum space, String key, Long consumerId, int count);

	/**
	 * 单条数据插入或者更新
	 * 
	 * @param dto
	 * @return
	 */
	@Deprecated
	Boolean insertOrUpdate(KVDto dto, Long consumerId);

}