package cn.com.duiba.kvtable.service.api.enums;

/**
 * activity-access-web Hbase第二段key枚举类
 * Created by sunchangji on 2018/7/11.
 */
public enum ActAccessWebHBaseKeyEnum {
    K001("种红包用户土地信息"),
    K002("种红包用户在种红包活动中使用的总积分"),
    K003("全局钱包自然月累计登录天数"),
    K004("推币机总的积分"),
    K005("推币机回收的积分"),
    K006("开心码助力信息"),

    K011("猜红包活动剩余预算"),
    K012("猜红包助力者永久可助力次数"),
    K013("猜红包红包总共可被猜次数"),
    K014("猜红包助力者已助力次数"),

    K015("百姓网师徒体系用户历史总共领红包金额"),
    K016("百姓网师徒体系活动总共已发金额"),

    K021("师徒组团活动日期"),

    K022("游戏中心红包领取状态"),
    K023("优酷活动引导页提示"),
    K024("优酷活动宝箱状态"),

    K025("百度打章鱼用户的总分数"),
    K026("百度打章鱼下载的次数"),
    K027("百度打章鱼分享的次数"),
    K028("百度打章鱼观看视频的次数"),
    K029("搜狐新闻打开宝箱记录"),
    K030("用户访问积分商城首页月记录"),
    ;

    private String desc;

    ActAccessWebHBaseKeyEnum(String desc){
        this.desc = desc;
    }

    /**
     * 活动web:activity-access-web HBase key space
     */
    private static final String SPACE = "AAWH";

    public String getDesc() {
        return desc;
    }

    /**
     * 拼接key前置
     */
    @Override
    public String toString() {
        return SPACE + "_" + super.toString()+"_";
    }
}
