package cn.com.duiba.kvtable.service.api.remoteservice.hbase;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kvtable.service.api.dto.HbaseKvBackendDto;

/**
 * 为自动化测试用例提供的专用接口
 * Created by sunchangji on 2018/11/3.
 */
@AdvancedFeignClient
public interface RemoteAutoTestApiService {

    /**
     * 根据rowkey查询数据
     *
     * @param rowkey        主键rowkey
     * @param rowkeyType       rowkey处理配型(cn.com.duiba.kvtable.service.api.enums.HbaseRowKeyTypeEnum)
     * @return HbaseKvBackendDto
     */
    HbaseKvBackendDto findByRowKey(String rowkey, int rowkeyType);

    /**
     * 根据rowkey删除数据
     *
     * @param rowkey        主键rowkey
     * @param rowkeyType    rowkey处理配型(cn.com.duiba.kvtable.service.api.enums.HbaseRowKeyTypeEnum)
     */
    void deleteByRowkey(String rowkey, int rowkeyType);

    /**
     * 更新hbase对应rowkey数据
     * @param hbaseKvBackendDto
     * @return
     */
    HbaseKvBackendDto updateByRowKey(HbaseKvBackendDto hbaseKvBackendDto);

    /**
     * 根据rowkey初始化hbase中数值的值,比如原来这个值是100,设置成想要的值,而不是increase
     *
     * @param hbaseKvBackendDto
     * @return
     */
    HbaseKvBackendDto resetLongValueByRowKey(HbaseKvBackendDto hbaseKvBackendDto);

}
