package cn.com.duiba.kvtable.service.api.params;

import cn.com.duiba.kvtable.service.api.enums.HbaseKeySpaceEnum;

import java.io.Serializable;

/**
 * Created by sunchangji on 2018/6/27.
 */
public class HbaseKvParam implements Serializable {
    private static final long serialVersionUID = -4909755654671907281L;
    /**
     * key类型
     */
    private HbaseKeySpaceEnum keySpaceEnum;

    /**
     * 客户端自定义的一段key
     */
    private String vkey;

    /**
     * 用户id
     */
    private Long consumerId;

    /**
     * 需要净增的值
     */
    private Long incrCount;

    public HbaseKeySpaceEnum getKeySpaceEnum() {
        return keySpaceEnum;
    }

    public void setKeySpaceEnum(HbaseKeySpaceEnum keySpaceEnum) {
        this.keySpaceEnum = keySpaceEnum;
    }

    public String getVkey() {
        return vkey;
    }

    public void setVkey(String vkey) {
        this.vkey = vkey;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getIncrCount() {
        return incrCount;
    }

    public void setIncrCount(Long incrCount) {
        this.incrCount = incrCount;
    }

    public String buildVkey() {
        if (this.vkey == null || consumerId == null || keySpaceEnum == null) {
            return null;
        }
        if(this.vkey.endsWith("_")){
            return keySpaceEnum.getSpace() + "_" + vkey + consumerId;
        }
        return keySpaceEnum.getSpace() + "_" + vkey + "_" + consumerId;
    }
}
