package cn.com.duiba.kvtable.service.api.enums;

/**
 * activity-comm-center 系统HBase key
 */
public enum ActCommCenterHBaseKey {

    K01("账户支付宝提现对应账户记录"),
    K02("总帐户支付宝提现累计金额"),
    K03("活动定制账户支付宝提现累计金额"),
    K04("自定义账户提现机会"),
    K05("自定义账户用户提现次数记录"),
    K06("自定义账户用户活动访问信息"),
    K07("总帐户已占可提现名额数量"),
    K08("总帐户已入账总金额")
    ;

    private String desc;

    ActCommCenterHBaseKey(String desc){
        this.desc = desc;
    }

    /**
     * activity-comm-center HBase key space
     */
    private static final String SPACE = "ACCH";

    public String getDesc() {
        return desc;
    }

    /**
     * 拼接key前置
     */
    @Override
    public String toString() {
        return SPACE + "_" + super.toString()+"_";
    }
}
