package cn.com.duiba.kvtable.service.api.remoteservice.hbase;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kvtable.service.api.dto.HbApiKLongVDto;
import cn.com.duiba.kvtable.service.api.dto.HbApiKStrVDto;
import cn.com.duiba.kvtable.service.api.params.hbapi.HbKStrVParam;

import java.util.List;

/**
 *
 * 已废弃,请使用 RemoteHbConsisHashKvService
 * <p>
 * 传入的rowkey底层反转rowkey来解决热点分布不均的问题,所以建议最后一段是用户id或者是商品id这样类似的唯一标识
 * <p>
 * Created by sunchangji on 2018/8/30.
 */
@Deprecated
@AdvancedFeignClient
public interface RemoteHbApiKvNoHotspotService {

    /**
     * 根据rowkey获取value是string类型的值
     *
     * @param rowkey
     * @return null表示不存在或该存储的值不是String类型
     */
    String getStringByKey(String rowkey);

    /**
     * 增加或更新字符串的value
     *
     * @param rowkey
     * @param value
     * @return
     */
    boolean upsertKStrV(String rowkey, String value);

    /**
     * 根据key获取value是long型的值,如果不是long的值会返回null
     *
     * @param rowkey
     * @return nnull表示不存在或该存储的值不是Long型
     */
    Long getLongByKey(String rowkey);

    /**
     * 增加或更新long类型的value
     *
     * @param rowkey
     * @param value
     * @return
     */
    boolean upsertKLongV(String rowkey, long value);

    /**
     * 对key的long value做increase操作,不存在会新增一条记录
     *
     * @param rowkey
     * @param incrNum
     * @return 返回increase后的值
     */
    Long increaseByKey(String rowkey, long incrNum);

    /**
     * 根据key删除
     *
     * @param rowkey
     */
    void deleteByKey(String rowkey);

    /**
     * 批量删除
     *
     * @param rowkeys
     */
    void batchDeleteByKeys(List<String> rowkeys);

    /**
     * 根据key批量查询value是long类型
     * 只要查到是按照传入的顺序,不存在的key是不会在返回的数据列表中
     *
     * @param keys
     * @return
     */
    List<HbApiKLongVDto> batchFindLongVBykeys(List<String> keys);


    /**
     * 根据key批量查询value是string类型
     * 只要查到是按照传入的顺序,不存在的key是不会在返回的数据列表中
     *
     * @param keys
     * @return
     */
    List<HbApiKStrVDto> batchFindStrVBykeys(List<String> keys);

    /**
     * 批量增加或更新value是字符串的value
     *
     * @param list
     * @return
     */
    void batchUpsertStrV(List<HbKStrVParam> list);

}
