package cn.com.duiba.kvtable.service.api.enums;

/**
 * activity-access-web Hbase第二段key枚举类
 * Created by sunchangji on 2018/7/11.
 */
public enum ActAccessWebHBaseKeyEnum {
    K001("种红包用户土地信息"),
    K002("种红包用户在种红包活动中使用的总积分"),
    K003("全局钱包自然月累计登录天数"),
    K004("推币机总的积分"),
    K005("推币机回收的积分"),
    K006("开心码助力信息"),
    K007("种红包用户总种植次数"),

    K011("猜红包活动剩余预算"),
    K012("猜红包助力者永久可助力次数"),
    K013("猜红包红包总共可被猜次数"),
    K014("猜红包助力者已助力次数"),

    K015("百姓网师徒体系用户历史总共领红包金额"),
    K016("百姓网师徒体系活动总共已发金额"),

    K021("师徒组团活动日期"),

    K022("游戏中心红包领取状态"),
    K023("优酷活动引导页提示"),
    K024("优酷活动宝箱状态"),

    K025("百度打章鱼用户的总分数"),
    K026("百度打章鱼下载的次数"),
    K027("百度打章鱼分享的次数"),
    K028("百度打章鱼观看视频的次数"),
    K029("搜狐新闻打开宝箱记录"),
    K030("用户访问积分商城首页月记录"),
    K031("用户获取红包途径配置"),

    K032("搜狐砍价活动用户帮砍次数"),
    K033("浙江农行夺宝码活动某期用户中奖弹窗次数"),

    K034("红包广场用户分享奖励领取次数"),
    K035("红包广场用户提现次数"),
    K036("红包广场用户分享次数"),

    K037("搬砖工活动用户累计登陆天数"),
    K038("搬砖工活动子订单"),
    K039("搬砖工活动用户首次召唤点击数"),

    K040("爱奇艺用户对应卡片参与抽奖次数"),
    K041("爱奇艺用户上次进入活动到本次进入，累计助力获得的卡片数量"),

    K042("搬砖活动用户首次进入拆分红包"),
    K043("红包广场-用户是否为当前活动新用户"),

    K045("集卡-用户转让卡剩余可领取次数"),

    K046("良品铺子拼拼乐-中奖轮播数据"),

    K047("拆红包工具-活动总共已发放金额"),

    K048("挖矿机活动-用户累积获得积分数"),

    K049("红包广场-提现支付宝账号绑定关系"),

    /**
     * 注：2019.03.01 后可联系产品@何劲草，确认定制代码是否可以移除
     */
    K051("网易星球猜红包活动定制-新用户红包额度"),

    K056("挖金矿活动子订单"),

    K057("海底游戏机-已参与抽奖次数"),
    K058("海底游戏机-已中奖品个数")

    ;

    private String desc;

    ActAccessWebHBaseKeyEnum(String desc){
        this.desc = desc;
    }

    /**
     * 活动web:activity-access-web HBase key space
     */
    private static final String SPACE = "AAWH";

    public String getDesc() {
        return desc;
    }

    /**
     * 拼接key前置
     */
    @Override
    public String toString() {
        return SPACE + "_" + super.toString()+"_";
    }
}
