package cn.com.duiba.kvtable.service.api.remoteservice.hbase;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duiba.kvtable.service.api.dto.DuibaKvtableDto;
import cn.com.duiba.kvtable.service.api.params.HbBatchIncreaseParam;
import cn.com.duiba.kvtable.service.api.params.HbaseKvParam;
import cn.com.duiba.kvtable.service.api.params.HbaseVKeyParam;

import java.util.List;

/**
 * 推荐使用RemoteHbConsisHashKvService
 *
 * Created by sunchangji on 2018/6/27.
 */
@Deprecated
@AdvancedFeignClient("kvtable-service")
@FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="2000")
public interface RemoteDuibaKvtableService {

    /**
     * 增加或更新数据
     *
     * @param kvtableDto
     * @return
     */
    boolean upsertKVTable(DuibaKvtableDto kvtableDto);

    /**
     * 根据单个key查询数据
     *
     * @param kvParam
     * @return
     */
    DuibaKvtableDto findByVkey(HbaseKvParam kvParam);

    /**
     * 增加数值,如果最终的key查询存在就会自增，
     * 如果不存在则会新增一条新纪录,intValue初始化值=incrCount
     *
     * @param kvParam
     */
    boolean increaseByKey(HbaseKvParam kvParam);

    /**
     * 根据key物理删除操作
     *
     * @param kvtableDto
     * @return
     */
    boolean deleteByVkey(DuibaKvtableDto kvtableDto);

    /**
     * 建议一次操作不要超过1千条,目前没有做强限制
     *
     * 批量Increase操作,存在就在此基础上增加,不存在就新增记录incrCount为初始值
     *
     * @param batchIncreaseParam
     * @return 影响行数,-1表示参数校验失败
     */
    int batchIncrease(HbBatchIncreaseParam batchIncreaseParam);

    /**
     * 批量新增或更新,如果vkey、keySpaceEnum、consumerId只要有一个为空就会跳过这个数据
     *
     * @param kvtableDtos
     * @return
     */
    boolean batchUpsert(List<DuibaKvtableDto> kvtableDtos);

    /**
     * 批量查询,keySpaceEnum，vkey，consumerId只要有一个为空就跳过
     * 查询的结果无顺序
     *
     * @param vKeyParams
     * @return
     */
    List<DuibaKvtableDto> batchFindByVkeys(List<HbaseVKeyParam> vKeyParams);
}
