package cn.com.duiba.kvtable.service.api.dto;

import cn.com.duiba.kvtable.service.api.enums.HbaseKeySpaceEnum;

import java.io.Serializable;

/**
 * Created by sunchangji on 2018/6/27.
 */
public class DuibaKvtableDto implements Serializable {
    private static final long serialVersionUID = 6293912215056580178L;

    /**
     * 唯一约束key,可以的组成是{HbaseKeyTypeEnum.space}_{vkey}_{consumerId}
     */
    private String vkey;

    /**
     * 用户ID
     */
    private Long consumerId;

    /**
     * 存储数字value
     */
    private Long intValue;

    /**
     * 存储字符串value
     */
    private String strValue;

    /**
     * vk类型
     */
    private HbaseKeySpaceEnum keySpaceEnum;

    public String getVkey() {
        return vkey;
    }

    public void setVkey(String vkey) {
        this.vkey = vkey;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getIntValue() {
        return intValue;
    }

    public void setIntValue(Long intValue) {
        this.intValue = intValue;
    }

    public String getStrValue() {
        return strValue;
    }

    public void setStrValue(String strValue) {
        this.strValue = strValue;
    }

    public HbaseKeySpaceEnum getKeySpaceEnum() {
        return keySpaceEnum;
    }

    public void setKeySpaceEnum(HbaseKeySpaceEnum keySpaceEnum) {
        this.keySpaceEnum = keySpaceEnum;
    }

    public String buildVkey() {
        if (this.vkey == null || consumerId == null || keySpaceEnum == null) {
            return null;
        }
        if(this.vkey.endsWith("_")){
            return keySpaceEnum.getSpace() + "_" + vkey + consumerId;
        }
        return keySpaceEnum.getSpace() + "_" + vkey + "_" + consumerId;
    }
}
