package cn.com.duiba.linglong.client.job.jobs;

import cn.com.duiba.linglong.client.job.ScheduleProperties;
import cn.com.duiba.linglong.client.job.interceptor.JobInterceptor;
import cn.com.duiba.linglong.client.job.interceptor.WithProcesserJob;
import cn.com.duiba.linglong.client.service.logger.JobLogger;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author liuyao
 */
@Slf4j
public class WorkerJobFactory {

    private List<JobInterceptor> interceptors;
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private ScheduleProperties scheduleProperties;
    @Value("${spring.application.name}")
    private String appName;


    @PostConstruct
    public void init(){
        for(Map.Entry<String,Class<? extends AbstractJob>> entry:scheduleProperties.getJobs().entrySet()){
            log.info("加载任务类型:{},Class:{}",entry.getKey(),entry.getValue().getName());
        }
    }

    public WithProcesserJob newInstanceJobByJobRunType(JobContext jobContext, JobLogger jobLogger){

        Class<? extends AbstractJob> jobType = scheduleProperties.getJobs().get(jobContext.getRunType());
        if(Objects.isNull(jobType)){
            throw new RuntimeException("不支持"+jobContext.getRunType()+"类型任务的调度,请在项目"+appName+"中使用配置[linglong.sdk.schedule."+jobContext.getRunType()+"]指定任务类型");
        }
        AbstractJob job = applicationContext.getBean(jobType);
        job.setJobContext(jobContext);
        job.setJobLogger(jobLogger);

        WithProcesserJob withProcesserJob = new WithProcesserJob();
        withProcesserJob.setInterceptors(interceptors);
        withProcesserJob.setJob(job);
        return withProcesserJob;
    }

    @Autowired
    public void setInterceptors(List<JobInterceptor> interceptors) {
        this.interceptors = interceptors;
    }
}
