package cn.com.duiba.linglong.client.job.render;

import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * @author liuyao
 */
public class DateTool extends Number {

    private final static ExpressionParser PARSER = new SpelExpressionParser();

    private final Long timestamp;

    public DateTool(Date date){
        this.timestamp = date.getTime();
    }

    public DateTool(Long timestamp){
        this.timestamp = timestamp;
    }

    public Object el(String elExpression){
        Expression expression = PARSER.parseExpression(elExpression);
        StandardEvaluationContext context = new StandardEvaluationContext();
        //注入时间常量
        context.setBeanResolver(new TimeConstantBeanResolver());
        return expression.getValue(context,this);
    }

    public DateTool addDay(int amount){
        return add(Calendar.DAY_OF_YEAR,amount);
    }

    public DateTool add(String fieldName, int amount){
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timestamp);

        if(!TimeConstantBeanResolver.FIELD_NAME_MAP.containsKey(fieldName)){
            throw new RuntimeException("无效的时间字段名称:"+fieldName);
        }
        int field = TimeConstantBeanResolver.FIELD_NAME_MAP.get(fieldName);
        calendar.add(field,amount);
        return new DateTool(calendar.getTimeInMillis());
    }

    public int field(String fieldName){
        if(!TimeConstantBeanResolver.FIELD_NAME_MAP.containsKey(fieldName)){
            throw new RuntimeException("无效的时间字段名称"+fieldName);
        }
        int field = TimeConstantBeanResolver.FIELD_NAME_MAP.get(fieldName);
        return field(field);
    }

    public int field(int field){
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timestamp);
        return calendar.get(field);
    }

    public DateTool add(int field, int amount){
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timestamp);
        calendar.add(field,amount);
        return new DateTool(calendar.getTimeInMillis());
    }

    public String format(String pattern){
        SimpleDateFormat format=new SimpleDateFormat(pattern);
        return format.format(new Date(timestamp));
    }

    public Long currentTimestamp(){
        return System.currentTimeMillis();
    }

    public Long getTimestamp() {
        return timestamp;
    }

    @Override
    public String toString() {
        return format("yyyy-MM-dd HH:mm:ss");
    }

    @Override
    public int intValue() {
        return timestamp.intValue();
    }

    @Override
    public long longValue() {
        return timestamp;
    }

    @Override
    public float floatValue() {
        return timestamp.floatValue();
    }

    @Override
    public double doubleValue() {
        return timestamp.doubleValue();
    }

    public static void main(String[] args) {
        DateTool tool = new DateTool(new Date());
        System.out.println(tool.el("@YEAR"));
        System.out.println(tool.el("#this.field('MONTH')"));
        System.out.println(tool.el("#this == #root"));
        System.out.println(tool.el("#this.field('MONTH') > 2 ? #this.field(@MONTH):#this.field(@MONTH)-10"));
        System.out.println(tool.el("#this.addDay(1)"));
        System.out.println(tool.el("#this.field(@DAY_OF_YEAR)"));
        System.out.println(tool.add("MONTH",4));
    }
}