/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.linglong.client.job.jobs;

import cn.com.duiba.linglong.client.job.ScheduleProperties;
import cn.com.duiba.linglong.client.job.interceptor.JobInterceptor;
import cn.com.duiba.linglong.client.job.interceptor.WithProcesserJob;
import cn.com.duiba.linglong.client.job.jobs.AbstractJob;
import cn.com.duiba.linglong.client.job.jobs.JobContext;
import cn.com.duiba.linglong.client.service.logger.JobLogger;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;

public class WorkerJobFactory {
    private static final Logger log = LoggerFactory.getLogger(WorkerJobFactory.class);
    private List<JobInterceptor> interceptors = Lists.newArrayList();
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private ScheduleProperties scheduleProperties;
    @Value(value="${spring.application.name}")
    private String appName;

    @PostConstruct
    public void init() {
        for (Map.Entry<String, Class<? extends AbstractJob>> entry : this.scheduleProperties.getJobs().entrySet()) {
            log.info("\u52a0\u8f7d\u4efb\u52a1\u7c7b\u578b:{},Class:{}", (Object)entry.getKey(), (Object)entry.getValue().getName());
        }
    }

    public WithProcesserJob newInstanceJobByJobRunType(JobContext jobContext, JobLogger jobLogger) {
        Class<? extends AbstractJob> jobType = this.scheduleProperties.getJobs().get(jobContext.getRunType());
        if (Objects.isNull(jobType)) {
            throw new RuntimeException("\u4e0d\u652f\u6301" + jobContext.getRunType() + "\u7c7b\u578b\u4efb\u52a1\u7684\u8c03\u5ea6,\u8bf7\u5728\u9879\u76ee" + this.appName + "\u4e2d\u4f7f\u7528\u914d\u7f6e[linglong.sdk.schedule.jobs." + jobContext.getRunType() + "]\u6307\u5b9a\u4efb\u52a1\u7c7b\u578b");
        }
        AbstractJob job = (AbstractJob)this.applicationContext.getBean(jobType);
        job.setJobContext(jobContext);
        job.setJobLogger(jobLogger);
        WithProcesserJob withProcesserJob = new WithProcesserJob();
        withProcesserJob.setInterceptors(this.interceptors);
        withProcesserJob.setJob(job);
        return withProcesserJob;
    }

    @Autowired(required=false)
    public void setInterceptors(List<JobInterceptor> interceptors) {
        this.interceptors = interceptors;
    }
}

