package cn.com.duiba.linglong.client.job.consumer;

import cn.com.duiba.linglong.client.domain.dto.JobKey;
import cn.com.duiba.linglong.client.domain.responce.WorkerResult;
import cn.com.duiba.linglong.client.job.jobs.WorkerScheduleJobManager;
import cn.com.duiba.linglong.client.service.channel.JobLevel;
import com.alibaba.fastjson.JSONArray;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author liuyao
 */
@RestController
@RequestMapping("/linglong/sdk")
public class WorkerJobController {

    @Resource
    private WorkerScheduleJobManager workerScheduleJobManager;

    @PostMapping("/submitJob")
    public WorkerResult submitJob(@RequestBody JobKey jobKey){
        workerScheduleJobManager.submitScheduleJob(jobKey, JobLevel.HIGH);
        return WorkerResult.successResult();
    }

    @GetMapping("/findAllRunnings")
    public JSONArray findAllRunnings(){
        JSONArray result = new JSONArray();
        List<JobKey> jobKeys = workerScheduleJobManager.findAllRunningJobs();
        result.addAll(jobKeys);
        return result;
    }

    @PostMapping("/cancelJob")
    public WorkerResult cancelJob(@RequestBody JobKey jobKey){
        workerScheduleJobManager.cancelJob(jobKey);
        return WorkerResult.successResult();
    }

}
