package cn.com.duiba.linglong.client.monitor;

import cn.com.duiba.linglong.client.job.consumer.JobConsumerAssert;
import com.sun.management.OperatingSystemMXBean;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Scheduled;

import javax.annotation.Resource;
import java.lang.management.ManagementFactory;

/**
 * @author liuyao
 */
@Slf4j
public class MemUseRateInfoService implements JobConsumerAssert {

	@Resource
	private MonitorProperties monitorProperties;

	private volatile Float memUseRate = 0f;

	private final OperatingSystemMXBean osmxb = (OperatingSystemMXBean) ManagementFactory.getOperatingSystemMXBean();

	@Scheduled(cron = "0/3 * * * * ?")
	public void runOneIteration() {
		// 总的物理内存+虚拟内存
		long totalvirtualMemory = osmxb.getTotalSwapSpaceSize();
		// 剩余的物理内存
		long freePhysicalMemorySize = osmxb.getFreePhysicalMemorySize();
		memUseRate = 1 - freePhysicalMemorySize * 1.0f  / totalvirtualMemory;
	}

	@Override
	public boolean canConsumer() {
		float maxMemRate = monitorProperties.getMaxMemRate();
		if(memUseRate>maxMemRate){
			log.info("内存过载：max("+maxMemRate+"),current:("+memUseRate+")");
			return false;
		}
		return true;
	}
}
