package cn.com.duiba.linglong.client.job;

import cn.com.duiba.linglong.client.job.jobs.AbstractJob;
import com.google.common.collect.Maps;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.Map;

/**
 * @author liuyao
 */
@Data
@ConfigurationProperties("linglong.sdk.schedule")
public class WorkerScheduleProperties {

    /**
     * 是否开启任务调度消费
     */
    private boolean enable = false;
    /**
     * 最大任务数
     */
    private Integer maxJobSize = 16;

    private Map<String,Class<? extends AbstractJob>> jobs = Maps.newHashMap();

}
