package cn.com.duiba.linglong.client.job.jobs;

import ch.qos.logback.classic.Level;
import cn.com.duiba.linglong.client.WorkerSdkProperties;
import cn.com.duiba.linglong.client.domain.dto.JobInvokerInfoDto;
import cn.com.duiba.linglong.client.domain.dto.JobKey;
import cn.com.duiba.linglong.client.domain.params.JobCallback;
import cn.com.duiba.linglong.client.domain.params.JobRunningCallback;
import cn.com.duiba.linglong.client.service.channel.JobLevel;
import cn.com.duiba.linglong.client.service.logger.JobLogger;
import cn.com.duiba.linglong.client.service.logger.JobLoggerBuilder;
import cn.com.duiba.wolf.utils.NetUtils;
import com.google.common.util.concurrent.AbstractExecutionThreadService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;

import javax.annotation.Resource;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

/**
 * @author liuyao
 */
@Slf4j
public class WorkerJobRunnable extends AbstractExecutionThreadService {

    @Resource
    private WorkerJobFactory workerJobFactory;
    @Resource
    private JobLoggerBuilder jobLoggerBuilder;
    @Resource(name="workerActionExecutorService")
    private ExecutorService workerActionExecutorService;
    @Resource
    private WorkerScheduleJobManager workerScheduleJobManager;
    @Value("${server.port}")
    private int httpServerPort;
    @Resource
    private WorkerSdkProperties workerSdkProperties;

    private volatile AbstractJob delegateJob;

    private JobKey jobKey;

    private JobLevel jobLevel;

    private JobLogger jobLogger;

    @Override
    protected void startUp() {
        jobLogger = jobLoggerBuilder.getJobLogger(jobKey);
    }

    @Override
    public void run() {

        JobCallback event = new JobCallback();
        event.setJobKey(jobKey);
        try {
            JobRunningCallback callback = new JobRunningCallback();
            callback.setJobKey(jobKey);
            callback.setAddress(NetUtils.getLocalIp()+":"+httpServerPort);

            JobInvokerInfoDto invokerInfo = workerScheduleJobManager.runningAck(callback);

            if(!workerSdkProperties.getTestModel()){
                JobContext jobContext = new JobContext();
                jobContext.setJobKey(jobKey);
                jobContext.setJobLevel(jobLevel);
                jobContext.setRunType(invokerInfo.getRunType());
                jobContext.setOwner(invokerInfo.getOwner());
                jobContext.setTime(invokerInfo.getFireTime());
                jobContext.setScript(invokerInfo.getScript());
                //注入默认配置信息
                jobContext.putAll(invokerInfo.getProperties());
                delegateJob = workerJobFactory.newInstanceJobByJobRunType(jobContext,jobLogger);
                delegateJob.run();//执行job
            }
            event.setSuccess(true);
        }catch (Exception e){
            jobLogger.error(e);
            event.setSuccess(false);
            event.setMessage(e.getMessage());
        }
        try{
            if(Objects.nonNull(delegateJob) && !delegateJob.isRunning()){
                return;
            }
            workerScheduleJobManager.jobCallback(event);
        }catch (Exception e){
            log.error("回调结果失败",e);
        }finally {
            workerScheduleJobManager.clearJob(jobKey);
        }
    }

    public void cancel(){
        if(Objects.nonNull(delegateJob) && delegateJob.isRunning()){
            delegateJob.cancel();
            jobLogger.log(Level.WARN,"取消任务");
        }
        if(isRunning()){
            stopAsync();
        }
    }

    @Override
    protected Executor executor() {
        return workerActionExecutorService;
    }

    public void setJobKey(JobKey jobKey) {
        this.jobKey = jobKey;
    }

    public void setJobLevel(JobLevel jobLevel){
        this.jobLevel = jobLevel;
    }
}
