/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.linglong.client.job;

import cn.com.duiba.linglong.client.job.WorkerScheduleProperties;
import cn.com.duiba.linglong.client.job.consumer.WorkerJobConsumer;
import cn.com.duiba.linglong.client.job.consumer.WorkerJobController;
import cn.com.duiba.linglong.client.job.jobs.WorkerJobFactory;
import cn.com.duiba.linglong.client.job.jobs.WorkerJobRunnable;
import cn.com.duiba.linglong.client.job.jobs.WorkerScheduleJobManager;
import cn.com.duiba.linglong.client.job.render.ConfigRender;
import cn.com.duiba.linglong.client.job.render.JobScriptInterceptor;
import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.annotation.Order;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnProperty(name={"linglong.sdk.schedule.enable"}, havingValue="true")
@EnableConfigurationProperties(value={WorkerScheduleProperties.class})
public class WorkerScheduleConfiguration {
    @Bean
    public WorkerJobConsumer workerJobConsumer() {
        return new WorkerJobConsumer();
    }

    @Bean
    public WorkerJobFactory workerJobFactory() {
        return new WorkerJobFactory();
    }

    @Bean
    public WorkerScheduleJobManager workerScheduleJobManager() {
        return new WorkerScheduleJobManager();
    }

    @Bean
    public WorkerJobController workerJobController() {
        return new WorkerJobController();
    }

    @Bean
    @Scope(value="prototype")
    public WorkerJobRunnable workerJobRunnable() {
        return new WorkerJobRunnable();
    }

    @Bean
    public ExecutorService workerActionExecutorService(WorkerScheduleProperties scheduleProperties) {
        NamedThreadFactory threadFactory = new NamedThreadFactory("workerAction");
        return new ThreadPoolExecutor((int)scheduleProperties.getMaxJobSize(), scheduleProperties.getMaxJobSize() * 2, 3L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(500), (ThreadFactory)threadFactory);
    }

    @Bean
    @Order(value=2)
    public JobScriptInterceptor jobScriptInterceptor() {
        return new JobScriptInterceptor();
    }

    @Bean(initMethod="init")
    public VelocityEngine velocityEngine() {
        VelocityEngine velocityEngine = new VelocityEngine();
        velocityEngine.setProperty("resource.loader", (Object)"classpath");
        velocityEngine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        velocityEngine.setProperty("input.encoding", (Object)"UTF-8");
        velocityEngine.setProperty("output.encoding", (Object)"UTF-8");
        return velocityEngine;
    }

    @Bean
    @Scope(value="prototype")
    public ConfigRender configRender() {
        return new ConfigRender();
    }

    @LoadBalanced
    @Bean
    public RestTemplate linglongFetchJobRestTemplate(HttpClient httpClient) {
        HttpComponentsClientHttpRequestFactory httpRequestFactory = new HttpComponentsClientHttpRequestFactory();
        httpRequestFactory.setConnectionRequestTimeout(3000);
        httpRequestFactory.setConnectTimeout(3000);
        httpRequestFactory.setReadTimeout(10000);
        httpRequestFactory.setHttpClient(httpClient);
        return new RestTemplate((ClientHttpRequestFactory)httpRequestFactory);
    }
}

