/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.linglong.client.job.jobs;

import ch.qos.logback.classic.Level;
import cn.com.duiba.linglong.client.WorkerSdkProperties;
import cn.com.duiba.linglong.client.domain.dto.JobInvokerInfoDto;
import cn.com.duiba.linglong.client.domain.dto.JobKey;
import cn.com.duiba.linglong.client.domain.params.JobCallback;
import cn.com.duiba.linglong.client.domain.params.JobRunningCallback;
import cn.com.duiba.linglong.client.job.jobs.AbstractJob;
import cn.com.duiba.linglong.client.job.jobs.JobContext;
import cn.com.duiba.linglong.client.job.jobs.WorkerJobFactory;
import cn.com.duiba.linglong.client.job.jobs.WorkerScheduleJobManager;
import cn.com.duiba.linglong.client.service.channel.JobLevel;
import cn.com.duiba.linglong.client.service.logger.JobLogger;
import cn.com.duiba.linglong.client.service.logger.JobLoggerBuilder;
import cn.com.duiba.wolf.utils.NetUtils;
import com.google.common.util.concurrent.AbstractExecutionThreadService;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class WorkerJobRunnable
extends AbstractExecutionThreadService {
    private static final Logger log = LoggerFactory.getLogger(WorkerJobRunnable.class);
    @Resource
    private WorkerJobFactory workerJobFactory;
    @Resource
    private JobLoggerBuilder jobLoggerBuilder;
    @Resource(name="workerActionExecutorService")
    private ExecutorService workerActionExecutorService;
    @Resource
    private WorkerScheduleJobManager workerScheduleJobManager;
    @Value(value="${server.port}")
    private int httpServerPort;
    @Resource
    private WorkerSdkProperties workerSdkProperties;
    private volatile AbstractJob delegateJob;
    private JobKey jobKey;
    private JobLevel jobLevel;
    private JobLogger jobLogger;

    protected void startUp() {
        this.jobLogger = this.jobLoggerBuilder.getJobLogger(this.jobKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        JobCallback event = new JobCallback();
        event.setJobKey(this.jobKey);
        try {
            JobRunningCallback callback = new JobRunningCallback();
            callback.setJobKey(this.jobKey);
            callback.setAddress(NetUtils.getLocalIp() + ":" + this.httpServerPort);
            JobInvokerInfoDto invokerInfo = this.workerScheduleJobManager.runningAck(callback);
            if (!this.workerSdkProperties.getTestModel().booleanValue()) {
                JobContext jobContext = new JobContext();
                jobContext.setJobKey(this.jobKey);
                jobContext.setJobLevel(this.jobLevel);
                jobContext.setRunType(invokerInfo.getRunType());
                jobContext.setOwner(invokerInfo.getOwner());
                jobContext.setTime(invokerInfo.getFireTime());
                jobContext.setScript(invokerInfo.getScript());
                jobContext.putAll((Map<?, ?>)invokerInfo.getProperties());
                this.delegateJob = this.workerJobFactory.newInstanceJobByJobRunType(jobContext, this.jobLogger);
                this.delegateJob.run();
            }
            event.setSuccess(true);
        }
        catch (Exception e) {
            this.jobLogger.error(e);
            event.setSuccess(false);
            event.setMessage(e.getMessage());
        }
        try {
            if (Objects.nonNull(this.delegateJob) && !this.delegateJob.isRunning()) {
                return;
            }
            this.workerScheduleJobManager.jobCallback(event);
        }
        catch (Exception e) {
            log.error("\u56de\u8c03\u7ed3\u679c\u5931\u8d25", (Throwable)e);
        }
        finally {
            this.workerScheduleJobManager.clearJob(this.jobKey);
        }
    }

    public void cancel() {
        if (Objects.nonNull(this.delegateJob) && this.delegateJob.isRunning()) {
            this.delegateJob.cancel();
            this.jobLogger.log(Level.WARN, "\u53d6\u6d88\u4efb\u52a1");
        }
        if (this.isRunning()) {
            this.stopAsync();
        }
    }

    protected Executor executor() {
        return this.workerActionExecutorService;
    }

    public void setJobKey(JobKey jobKey) {
        this.jobKey = jobKey;
    }

    public void setJobLevel(JobLevel jobLevel) {
        this.jobLevel = jobLevel;
    }
}

