/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.linglong.client.service.logger;

import ch.qos.logback.classic.Level;
import cn.com.duiba.linglong.client.domain.dto.JobKey;
import cn.com.duiba.linglong.client.exception.WorkerException;
import cn.com.duiba.linglong.client.service.logger.JobLog;
import cn.com.duiba.linglong.client.service.logger.appender.JobLoggerAppender;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobLogger {
    private static final Logger log = LoggerFactory.getLogger(JobLogger.class);
    public static final int JOB_LOG_CONUT_LIMIT = 10000;
    private final JobLoggerAppender jobLoggerAppender;
    private final JobKey jobKey;
    private final AtomicInteger jobLogCount = new AtomicInteger(0);
    private volatile boolean isUp = false;

    public JobLogger(JobLoggerAppender jobLoggerAppender, JobKey jobKey) {
        this.jobLoggerAppender = jobLoggerAppender;
        this.jobKey = jobKey;
    }

    public JobKey getJobKey() {
        return this.jobKey;
    }

    public void log(String log) {
        this.log(null, log);
    }

    public void error(Throwable e) {
        if (e instanceof WorkerException) {
            this.log(Level.ERROR, e.getMessage());
        } else if (e instanceof NullPointerException) {
            StringWriter out = new StringWriter();
            try (PrintWriter stream = new PrintWriter(out);){
                e.printStackTrace(stream);
                this.log(Level.ERROR, "\u4efb\u52a1\u7a7a\u6307\u9488\u5f02\u5e38:" + out);
            }
        } else {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            this.log(Level.ERROR, sw.toString());
        }
    }

    public void log(Level level, String logContent) {
        if (StringUtils.isBlank((String)logContent)) {
            return;
        }
        int count = this.jobLogCount.getAndIncrement();
        if (count > 10000) {
            if (!this.isUp) {
                String context = "\u4efb\u52a1[" + this.jobKey.key() + "]\u65e5\u5fd7\u91cf\u8d85\u8fc7" + 10000 + ",\u65e0\u6cd5\u7ee7\u7eed\u8bb0\u5f55";
                JobLog jobLog = new JobLog();
                jobLog.setActionTime(System.currentTimeMillis());
                jobLog.setLogContent(context);
                jobLog.setLevel(Level.ERROR.toString());
                this.jobLoggerAppender.acceptLog(this.jobKey, jobLog);
            }
            this.isUp = true;
            return;
        }
        JobLog jobLog = new JobLog();
        jobLog.setActionTime(System.currentTimeMillis());
        jobLog.setLogContent(logContent);
        jobLog.setLevel(Optional.ofNullable(level).orElse(Level.INFO).toString());
        this.jobLoggerAppender.acceptLog(this.jobKey, jobLog);
    }
}

