package cn.com.duiba.linglong.client.job.jobs;

import cn.com.duiba.linglong.client.job.WorkerScheduleProperties;
import cn.com.duibaboot.ext.autoconfigure.core.utils.PropertyResolver;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

import java.util.Map;

@Slf4j
public class WorkerJobBeanFactoryPostProcessor implements BeanDefinitionRegistryPostProcessor,EnvironmentAware {
    private Map<String,Class<? extends AbstractJob>> jobInfos;

    @Override
    public void postProcessBeanDefinitionRegistry(@NotNull BeanDefinitionRegistry registry) throws BeansException {

        for(Map.Entry<String,Class<? extends AbstractJob>> entry:jobInfos.entrySet()){
            String jobType = entry.getKey();
            Class<? extends AbstractJob> jobClass = entry.getValue();

            log.info("加载任务类型:{},Class:{}",entry.getKey(),entry.getValue().getName());

            GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
            beanDefinition.setBeanClass(jobClass);
            beanDefinition.setScope(BeanDefinition.SCOPE_PROTOTYPE);
            beanDefinition.setAutowireCandidate(true);
            registry.registerBeanDefinition("$$LinglongJob:"+jobType,beanDefinition);
        }
    }

    @Override
    public void postProcessBeanFactory(@NotNull ConfigurableListableBeanFactory beanFactory) throws BeansException {
        //nothing
    }

    @Override
    public void setEnvironment(@NotNull Environment environment) {
        PropertyResolver resolver = new PropertyResolver(environment,"linglong.sdk.schedule");
        WorkerScheduleProperties workerScheduleProperties = resolver.bindToConfig(WorkerScheduleProperties.class);
        this.jobInfos = workerScheduleProperties.getJobs();
    }


}
