package cn.com.duiba.linglong.client.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.linglong.client.domain.dto.JobDto;
import cn.com.duiba.linglong.client.domain.params.JobScriptUpdateParams;
import cn.com.duiba.linglong.client.domain.params.RunJobParams;
import cn.com.duiba.linglong.client.domain.params.SearchJobParams;
import cn.com.duiba.linglong.client.domain.responce.RunJobResult;

import javax.validation.Valid;
import java.util.List;

@AdvancedFeignClient
public interface RemoteJobApiService {

    /**
     * 查询单个
     * @param jobId 任务id
     * @return 任务
     */
    JobDto findOneJob(Long jobId) throws BizException;

    /**
     * 查询任务脚本
     * @param jobId 任务id
     * @return 脚本
     */
    String findJobScript(Long jobId) throws BizException;

    /**
     * 修改任务脚本
     * @param params 参数
     */
    void updateJobScript(JobScriptUpdateParams params) throws BizException;

    /**
     * 检索空间下任务
     * @param spaceKey 空间标识
     * @param params 检索条件
     * @return 任务列表
     */
    List<JobDto> searchJob(String spaceKey, SearchJobParams params) throws BizException;

    /**
     * 切换任务的自动调度开关
     * @param spaceKey 空间标识
     * @param jobId 任务
     * @return 开关状态
     */
    Boolean toggleJobAuto(Long jobId) throws BizException;

    /**
     * 手动触发任务执行
     */
    RunJobResult runJob(@Valid RunJobParams params) throws BizException;

}
